var StickyTableRows = function(option){
    "use strict";
    this.options = $.extend({},{
        parent: 'table',
        offset: 5,

    },option)
    
    this.rowsToStick = [];
    

    this.getWindowPosition = function(){return document.documentElement.scrollTop;};

    this.add = function(row){
        this.rowsToStick.push(row);
    };

    this.throttle = function(callback, limit){
        var wait = false; 
        var self = this;
        return function(element){
            if(wait) {
                return;
            }
            callback.call(self, element);
            wait = true;
            setTimeout(function(){wait = false;}, limit);
        }
    }

    this.checkScopeAndApply = function(idx, element, resetCallback){
        var height = $(element).outerHeight();
        var topBarHeight = $('.navbar.navbar-default.navbar-fixed-top').height();
        var elementParentPosition = $(element).closest(this.options.parent).offset().top;
        var elementParentPositionEnd = $(element).closest(this.options.parent).offset().top + $(element).closest(this.options.parent).height();
        var windowPosition = this.getWindowPosition();
        var stickElementExists = $('#stickyElement-'+idx).length > 0;
        var stickElement = stickElementExists ? $('#stickyElement-'+idx) : $(element).clone().attr('id', 'stickyElement-'+idx).addClass('stickyBar');
        var questionBackgroundColor = $(element).closest('div.question-container').css('background-color');
        
        if( 
            elementParentPositionEnd-height >= windowPosition 
            && elementParentPosition-(topBarHeight - Math.floor(height/2)) <= windowPosition
        ) {
            var width = $(element).outerWidth();
            var left = $(element).offset().left;
            var position = '1px';
            
            $(element).closest(this.options.parent).addClass('sticky')
            
            $(stickElement).children().each(function(i){
                if( $(this).data('css') !== true) {
                    $(this).css({
                        width: $($(element).children().eq(i)).outerWidth()+'px',
                        height: $($(element).children().eq(i)).outerHeight()+'px',
                    }).data('css', true);
                }
            });

            questionBackgroundColor = questionBackgroundColor=='transparent' || /^rgba(\d{1,3},\d{1,3},\d{1,3},0)$/.test(questionBackgroundColor) ? 'white' : questionBackgroundColor;
            stickElement.css({
                position: 'fixed',
                'background-color': questionBackgroundColor,
                top: (topBarHeight)+'px',
                height:  '1px',
                width: width+'px',
                left: left+'px',
                'z-index': 2002
            }).prependTo($(element).closest(this.options.parent));

            if(!stickElementExists) {
                stickElement.animate({ height:  height+'px',  top: (topBarHeight)+'px'}, 250);
            } else {
                stickElement.css({ height:  height+'px',  top: (topBarHeight)+'px'});
            }

        } else {
            resetCallback(stickElement);
        }
    }

    this.init = function(){
        var self = this;
        console.ls.log('STICKY','Initializing Sticky')
        $(window).on("scroll", function(){ self.onScrollHandler.apply(self, arguments); } );
    };

    this.onScrollHandler = function(event) {
        var self = this;
        $.each(this.rowsToStick, function(idx, element){
            var resetCallback = self.throttle(function(stickElement){
                $(stickElement).closest(self.options.parent).removeClass('sticky');
                $(stickElement).remove();
            },1000);
           self.checkScopeAndApply(idx, element,resetCallback);
        });
    };

    return this;
};