﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['nl']={"application":"Rich Text Editor","editor":"Tekstverwerker","editorPanel":"Tekstverwerker beheerpaneel","common":{"editorHelp":"Druk ALT 0 voor hulp","browseServer":"Bladeren op server","url":"URL","protocol":"Protocol","upload":"Upload","uploadSubmit":"Naar server verzenden","image":"Afbeelding","form":"Formulier","checkbox":"Selectievinkje","radio":"Keuzerondje","textField":"Tekstveld","textarea":"Tekstvak","hiddenField":"Verborgen veld","button":"Knop","select":"Selectieveld","imageButton":"Afbeeldingsknop","notSet":"<niet ingevuld>","id":"Id","name":"Naam","langDir":"Schrijfrichting","langDirLtr":"Links naar rechts (LTR)","langDirRtl":"Rechts naar links (RTL)","langCode":"Taalcode","longDescr":"Lange URL-omschrijving","cssClass":"Stylesheet-klassen","advisoryTitle":"Adviserende titel","cssStyle":"Stijl","ok":"OK","cancel":"Annuleren","close":"Sluiten","preview":"Voorbeeld","resize":"Sleep om te herschalen","generalTab":"Algemeen","advancedTab":"Geavanceerd","validateNumberFailed":"Deze waarde is geen geldig getal.","confirmNewPage":"Alle aangebrachte wijzigingen gaan verloren. Weet u zeker dat u een nieuwe pagina wilt openen?","confirmCancel":"Enkele opties zijn gewijzigd. Weet u zeker dat u dit dialoogvenster wilt sluiten?","options":"Opties","target":"Doelvenster","targetNew":"Nieuw venster (_blank)","targetTop":"Hele venster (_top)","targetSelf":"Zelfde venster (_self)","targetParent":"Origineel venster (_parent)","langDirLTR":"Links naar rechts (LTR)","langDirRTL":"Rechts naar links (RTL)","styles":"Stijl","cssClasses":"Stylesheet-klassen","width":"Breedte","height":"Hoogte","align":"Uitlijning","left":"Links","right":"Rechts","center":"Centreren","justify":"Uitvullen","alignLeft":"Links uitlijnen","alignRight":"Rechts uitlijnen","alignCenter":"Centreren","alignTop":"Boven","alignMiddle":"Midden","alignBottom":"Onder","alignNone":"Geen","invalidValue":"Ongeldige waarde.","invalidHeight":"De hoogte moet een getal zijn.","invalidWidth":"De breedte moet een getal zijn.","invalidLength":"Value specified for the \"%1\" field must be a positive number with or without a valid measurement unit (%2).","invalidCssLength":"Waarde in veld \"%1\" moet een positief nummer zijn, met of zonder een geldige CSS meeteenheid (px, %, in, cm, mm, em, ex, pt of pc).","invalidHtmlLength":"Waarde in veld \"%1\" moet een positief nummer zijn, met of zonder een geldige HTML meeteenheid (px of %).","invalidInlineStyle":"Waarde voor de online stijl moet bestaan uit een of meerdere tupels met het formaat \"naam : waarde\", gescheiden door puntkomma's.","cssLengthTooltip":"Geef een nummer in voor een waarde in pixels of geef een nummer in met een geldige CSS eenheid (px, %, in, cm, mm, em, ex, pt, of pc).","unavailable":"%1<span class=\"cke_accessibility\">, niet beschikbaar</span>","keyboard":{"8":"Backspace","13":"Enter","16":"Shift","17":"Ctrl","18":"Alt","32":"Spatie","35":"End","36":"Home","46":"Verwijderen","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Command"},"keyboardShortcut":"Sneltoets","optionDefault":"Standaard"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Alle rechten voorbehouden.","dlgTitle":"Over CKEditor 4","moreInfo":"Bezoek onze website voor licentieinformatie:"},"basicstyles":{"bold":"Vet","italic":"Cursief","strike":"Doorhalen","subscript":"Subscript","superscript":"Superscript","underline":"Onderstrepen"},"bidi":{"ltr":"Schrijfrichting van links naar rechts","rtl":"Schrijfrichting van rechts naar links"},"blockquote":{"toolbar":"Citaatblok"},"notification":{"closed":"Melding gesloten."},"toolbar":{"toolbarCollapse":"Werkbalk inklappen","toolbarExpand":"Werkbalk uitklappen","toolbarGroups":{"document":"Document","clipboard":"Klembord/Ongedaan maken","editing":"Bewerken","forms":"Formulieren","basicstyles":"Basisstijlen","paragraph":"Paragraaf","links":"Links","insert":"Invoegen","styles":"Stijlen","colors":"Kleuren","tools":"Toepassingen"},"toolbars":"Werkbalken"},"clipboard":{"copy":"Kopiëren","copyError":"De beveiligingsinstelling van de browser verhinderen het automatisch kopiëren. Gebruik de sneltoets Ctrl/Cmd+C van het toetsenbord.","cut":"Knippen","cutError":"De beveiligingsinstelling van de browser verhinderen het automatisch knippen. Gebruik de sneltoets Ctrl/Cmd+X van het toetsenbord.","paste":"Plakken","pasteNotification":"Plakken met de knop in de werkbalk wordt niet ondersteund door de browser. Gebruik de sneltoets %1 van het toetsenbord.","pasteArea":"Plakgebied","pasteMsg":"Plak de inhoud in het vak hieronder en druk op OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automatisch","bgColorTitle":"Achtergrondkleur","colors":{"000":"Zwart","800000":"Kastanjebruin","8B4513":"Chocoladebruin","2F4F4F":"Donkerleigrijs","008080":"Blauwgroen","000080":"Marine","4B0082":"Indigo","696969":"Donkergrijs","B22222":"Baksteen","A52A2A":"Bruin","DAA520":"Donkergeel","006400":"Donkergroen","40E0D0":"Turquoise","0000CD":"Middenblauw","800080":"Paars","808080":"Grijs","F00":"Rood","FF8C00":"Donkeroranje","FFD700":"Goud","008000":"Groen","0FF":"Cyaan","00F":"Blauw","EE82EE":"Violet","A9A9A9":"Donkergrijs","FFA07A":"Lichtzalm","FFA500":"Oranje","FFFF00":"Geel","00FF00":"Felgroen","AFEEEE":"Lichtturquoise","ADD8E6":"Lichtblauw","DDA0DD":"Pruim","D3D3D3":"Lichtgrijs","FFF0F5":"Linnen","FAEBD7":"Ivoor","FFFFE0":"Lichtgeel","F0FFF0":"Honingdauw","F0FFFF":"Azuur","F0F8FF":"Licht hemelsblauw","E6E6FA":"Lavendel","FFF":"Wit","1ABC9C":"Strong Cyan","2ECC71":"Smaragdgroen","3498DB":"Helderblauw","9B59B6":"Amethyst","4E5F70":"Grayish Blue","F1C40F":"Vivid Yellow","16A085":"Dark Cyan","27AE60":"Dark Emerald","2980B9":"Strong Blue","8E44AD":"Dark Violet","2C3E50":"Desaturated Blue","F39C12":"Oranje","E67E22":"Wortel","E74C3C":"Pale Red","ECF0F1":"Bright Silver","95A5A6":"Light Grayish Cyan","DDD":"Light Gray","D35400":"Pompoen","C0392B":"Strong Red","BDC3C7":"Zilver","7F8C8D":"Grayish Cyan","999":"Donkergrijs"},"more":"Meer kleuren...","panelTitle":"Kleuren","textColorTitle":"Tekstkleur"},"colordialog":{"clear":"Wissen","highlight":"Actief","options":"Kleuropties","selected":"Geselecteerde kleur","title":"Selecteer kleur"},"templates":{"button":"Sjablonen","emptyListMsg":"(Geen sjablonen gedefinieerd)","insertOption":"Vervang de huidige inhoud","options":"Template opties","selectPromptMsg":"Selecteer het sjabloon dat in de editor geopend moet worden (de actuele inhoud gaat verloren):","title":"Inhoud sjablonen"},"contextmenu":{"options":"Contextmenu opties"},"copyformatting":{"label":"Opmaakstijl kopiëren","notification":{"copied":"Opmaakstijl gekopieerd","applied":"Opmaakstijl toegepast","canceled":"Opmaakstijl toepassen geannuleerd","failed":"Opmaakstijl toepassen mislukt. U kunt geen opmaakstijl toepassen zonder deze eerst te kopiëren."}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Adviserende titel","cssClassInputLabel":"Stylesheet klassen","edit":"Div wijzigen","inlineStyleInputLabel":"Inline stijl","langDirLTRLabel":"Links naar rechts (LTR)","langDirLabel":"Schrijfrichting","langDirRTLLabel":"Rechts naar links (RTL)","languageCodeInputLabel":" Taalcode","remove":"Div verwijderen","styleSelectLabel":"Stijl","title":"Div aanmaken","toolbar":"Div aanmaken"},"elementspath":{"eleLabel":"Elementenpad","eleTitle":"%1 element"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Fout tijdens lezen van bestand.","networkError":"Netwerkfout tijdens uploaden van bestand.","httpError404":"HTTP fout tijdens uploaden van bestand (404: Bestand niet gevonden).","httpError403":"HTTP fout tijdens uploaden van bestand (403: Verboden).","httpError":"HTTP fout tijdens uploaden van bestand (fout status: %1).","noUrlError":"Upload URL is niet gedefinieerd.","responseError":"Ongeldig antwoord van server."},"find":{"find":"Zoeken","findOptions":"Zoekopties","findWhat":"Zoeken naar:","matchCase":"Hoofdlettergevoelig","matchCyclic":"Doorlopend zoeken","matchWord":"Hele woord moet voorkomen","notFoundMsg":"De opgegeven tekst is niet gevonden.","replace":"Vervangen","replaceAll":"Alles vervangen","replaceSuccessMsg":"%1 resultaten vervangen.","replaceWith":"Vervangen met:","title":"Zoeken en vervangen"},"font":{"fontSize":{"label":"Lettergrootte","voiceLabel":"Lettergrootte","panelTitle":"Lettergrootte"},"label":"Lettertype","panelTitle":"Lettertype","voiceLabel":"Lettertype"},"fakeobjects":{"anchor":"Interne link","hiddenfield":"Verborgen veld","iframe":"IFrame","unknown":"Onbekend object"},"forms":{"button":{"title":"Eigenschappen knop","text":"Tekst (waarde)","type":"Soort","typeBtn":"Knop","typeSbm":"Versturen","typeRst":"Leegmaken"},"checkboxAndRadio":{"checkboxTitle":"Eigenschappen aanvinkvakje","radioTitle":"Eigenschappen selectievakje","value":"Waarde","selected":"Geselecteerd","required":"Vereist"},"form":{"title":"Eigenschappen formulier","menu":"Eigenschappen formulier","action":"Actie","method":"Methode","encoding":"Codering"},"hidden":{"title":"Eigenschappen verborgen veld","name":"Naam","value":"Waarde"},"select":{"title":"Eigenschappen selectieveld","selectInfo":"Informatie","opAvail":"Beschikbare opties","value":"Waarde","size":"Grootte","lines":"Regels","chkMulti":"Gecombineerde selecties toestaan","required":"Vereist","opText":"Tekst","opValue":"Waarde","btnAdd":"Toevoegen","btnModify":"Wijzigen","btnUp":"Omhoog","btnDown":"Omlaag","btnSetValue":"Als geselecteerde waarde instellen","btnDelete":"Verwijderen"},"textarea":{"title":"Eigenschappen tekstvak","cols":"Kolommen","rows":"Rijen"},"textfield":{"title":"Eigenschappen tekstveld","name":"Naam","value":"Waarde","charWidth":"Breedte (tekens)","maxChars":"Maximum aantal tekens","required":"Vereist","type":"Soort","typeText":"Tekst","typePass":"Wachtwoord","typeEmail":"E-mail","typeSearch":"Zoeken","typeTel":"Telefoonnummer","typeUrl":"URL"}},"format":{"label":"Opmaak","panelTitle":"Opmaak","tag_address":"Adres","tag_div":"Normaal (DIV)","tag_h1":"Kop 1","tag_h2":"Kop 2","tag_h3":"Kop 3","tag_h4":"Kop 4","tag_h5":"Kop 5","tag_h6":"Kop 6","tag_p":"Normaal","tag_pre":"Met opmaak"},"horizontalrule":{"toolbar":"Horizontale lijn invoegen"},"iframe":{"border":"Framerand tonen","noUrl":"Vul de IFrame URL in","scrolling":"Scrollbalken inschakelen","title":"IFrame-eigenschappen","toolbar":"IFrame","tabindex":"Remove from tabindex"},"image":{"alt":"Alternatieve tekst","border":"Rand","btnUpload":"Naar server verzenden","button2Img":"Wilt u de geselecteerde afbeeldingsknop vervangen door een eenvoudige afbeelding?","hSpace":"HSpace","img2Button":"Wilt u de geselecteerde afbeelding vervangen door een afbeeldingsknop?","infoTab":"Informatie afbeelding","linkTab":"Link","lockRatio":"Afmetingen vergrendelen","menu":"Eigenschappen afbeelding","resetSize":"Afmetingen resetten","title":"Eigenschappen afbeelding","titleButton":"Eigenschappen afbeeldingsknop","upload":"Upload","urlMissing":"De URL naar de afbeelding ontbreekt.","vSpace":"VSpace","validateBorder":"Rand moet een heel nummer zijn.","validateHSpace":"HSpace moet een heel nummer zijn.","validateVSpace":"VSpace moet een heel nummer zijn."},"indent":{"indent":"Inspringing vergroten","outdent":"Inspringing verkleinen"},"smiley":{"options":"Smiley opties","title":"Smiley invoegen","toolbar":"Smiley"},"language":{"button":"Taal instellen","remove":"Taal verwijderen"},"link":{"acccessKey":"Toegangstoets","advanced":"Geavanceerd","advisoryContentType":"Aanbevolen content-type","advisoryTitle":"Adviserende titel","anchor":{"toolbar":"Interne link","menu":"Eigenschappen interne link","title":"Eigenschappen interne link","name":"Naam interne link","errorName":"Geef de naam van de interne link op","errorWhitespace":"Anchor name cannot contain space characters","remove":"Interne link verwijderen"},"anchorId":"Op kenmerk interne link","anchorName":"Op naam interne link","charset":"Karakterset van gelinkte bron","cssClasses":"Stylesheet-klassen","download":"Download forceren","displayText":"Weergavetekst","emailAddress":"E-mailadres","emailBody":"Inhoud bericht","emailSubject":"Onderwerp bericht","id":"Id","info":"Linkomschrijving","langCode":"Taalcode","langDir":"Schrijfrichting","langDirLTR":"Links naar rechts (LTR)","langDirRTL":"Rechts naar links (RTL)","menu":"Link wijzigen","name":"Naam","noAnchors":"(Geen interne links in document gevonden)","noEmail":"Geef een e-mailadres","noUrl":"Geef de link van de URL","noTel":"Geef een telefoonnummer","other":"<ander>","phoneNumber":"Telefoonnummer","popupDependent":"Afhankelijk (Netscape)","popupFeatures":"Instellingen popupvenster","popupFullScreen":"Volledig scherm (IE)","popupLeft":"Positie links","popupLocationBar":"Locatiemenu","popupMenuBar":"Menubalk","popupResizable":"Herschaalbaar","popupScrollBars":"Schuifbalken","popupStatusBar":"Statusbalk","popupToolbar":"Werkbalk","popupTop":"Positie boven","rel":"Relatie","selectAnchor":"Kies een interne link","styles":"Stijl","tabIndex":"Tabvolgorde","target":"Doelvenster","targetFrame":"<frame>","targetFrameName":"Naam doelframe","targetPopup":"<popupvenster>","targetPopupName":"Naam popupvenster","title":"Link","toAnchor":"Interne link in pagina","toEmail":"E-mail","toUrl":"URL","toPhone":"Telefoon","toolbar":"Link invoegen/wijzigen","type":"Linktype","unlink":"Link verwijderen","upload":"Upload"},"list":{"bulletedlist":"Opsomming invoegen","numberedlist":"Genummerde lijst invoegen"},"liststyle":{"bulletedTitle":"Eigenschappen lijst met opsommingstekens","circle":"Cirkel","decimal":"Cijfers (1, 2, 3, etc.)","disc":"Schijf","lowerAlpha":"Kleine letters (a, b, c, d, e, etc.)","lowerRoman":"Romeins kleine letters (i, ii, iii, iv, v, etc.)","none":"Geen","notset":"<niet gezet>","numberedTitle":"Eigenschappen genummerde lijst","square":"Vierkant","start":"Start","type":"Type","upperAlpha":"Hoofdletters (A, B, C, D, E, etc.)","upperRoman":"Romeinse hoofdletters (I, II, III, IV, V, etc.)","validateStartNumber":"Startnummer van de lijst moet een heel nummer zijn."},"magicline":{"title":"Hier paragraaf invoeren"},"maximize":{"maximize":"Maximaliseren","minimize":"Minimaliseren"},"newpage":{"toolbar":"Nieuwe pagina"},"pagebreak":{"alt":"Pagina-einde","toolbar":"Pagina-einde invoegen"},"pastetext":{"button":"Plakken als platte tekst","pasteNotification":"Plakken met de knop in de werkbalk wordt niet ondersteund door de browser. Gebruik de sneltoets %1 van het toetsenbord.","title":"Plakken als platte tekst"},"pastefromword":{"confirmCleanup":"De tekst die u wilt plakken lijkt gekopieerd te zijn vanuit Word. Wilt u de tekst opschonen voordat deze geplakt wordt?","error":"Het was niet mogelijk om de geplakte tekst op te schonen door een interne fout","title":"Plakken vanuit Word","toolbar":"Plakken vanuit Word"},"preview":{"preview":"Voorbeeld"},"print":{"toolbar":"Afdrukken"},"removeformat":{"toolbar":"Opmaak verwijderen"},"save":{"toolbar":"Opslaan"},"selectall":{"toolbar":"Alles selecteren"},"showblocks":{"toolbar":"Toon blokken"},"sourcearea":{"toolbar":"Broncode"},"specialchar":{"options":"Speciale tekens opties","title":"Selecteer speciaal teken","toolbar":"Speciaal teken invoegen"},"scayt":{"btn_about":"Over SCAYT","btn_dictionaries":"Woordenboeken","btn_disable":"SCAYT uitschakelen","btn_enable":"SCAYT inschakelen","btn_langs":"Talen","btn_options":"Opties","text_title":"Controleer de spelling tijdens het typen"},"stylescombo":{"label":"Stijl","panelTitle":"Opmaakstijlen","panelTitle1":"Blok stijlen","panelTitle2":"Inline stijlen","panelTitle3":"Object stijlen"},"table":{"border":"Randdikte","caption":"Bijschrift","cell":{"menu":"Cel","insertBefore":"Voeg cel in voor","insertAfter":"Voeg cel in na","deleteCell":"Cellen verwijderen","merge":"Cellen samenvoegen","mergeRight":"Voeg samen naar rechts","mergeDown":"Voeg samen naar beneden","splitHorizontal":"Splits cel horizontaal","splitVertical":"Splits cel vertikaal","title":"Celeigenschappen","cellType":"Celtype","rowSpan":"Rijen samenvoegen","colSpan":"Kolommen samenvoegen","wordWrap":"Automatische terugloop","hAlign":"Horizontale uitlijning","vAlign":"Verticale uitlijning","alignBaseline":"Tekstregel","bgColor":"Achtergrondkleur","borderColor":"Randkleur","data":"Gegevens","header":"Kop","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Ja","no":"Nee","invalidWidth":"De celbreedte moet een getal zijn.","invalidHeight":"De celhoogte moet een getal zijn.","invalidRowSpan":"Rijen samenvoegen moet een heel getal zijn.","invalidColSpan":"Kolommen samenvoegen moet een heel getal zijn.","chooseColor":"Kies"},"cellPad":"Celopvulling","cellSpace":"Celafstand","column":{"menu":"Kolom","insertBefore":"Voeg kolom in voor","insertAfter":"Voeg kolom in na","deleteColumn":"Kolommen verwijderen"},"columns":"Kolommen","deleteTable":"Tabel verwijderen","headers":"Koppen","headersBoth":"Beide","headersColumn":"Eerste kolom","headersNone":"Geen","headersRow":"Eerste rij","heightUnit":"height unit","invalidBorder":"De randdikte moet een getal zijn.","invalidCellPadding":"Celopvulling moet een getal zijn.","invalidCellSpacing":"Celafstand moet een getal zijn.","invalidCols":"Het aantal kolommen moet een getal zijn groter dan 0.","invalidHeight":"De tabelhoogte moet een getal zijn.","invalidRows":"Het aantal rijen moet een getal zijn groter dan 0.","invalidWidth":"De tabelbreedte moet een getal zijn.","menu":"Tabeleigenschappen","row":{"menu":"Rij","insertBefore":"Voeg rij in voor","insertAfter":"Voeg rij in na","deleteRow":"Rijen verwijderen"},"rows":"Rijen","summary":"Samenvatting","title":"Tabeleigenschappen","toolbar":"Tabel","widthPc":"procent","widthPx":"pixels","widthUnit":"eenheid breedte"},"undo":{"redo":"Opnieuw uitvoeren","undo":"Ongedaan maken"},"widget":{"move":"Klik en sleep om te verplaatsen","label":"%1 widget"},"uploadwidget":{"abort":"Upload gestopt door de gebruiker.","doneOne":"Bestand succesvol geüpload.","doneMany":"Succesvol %1 bestanden geüpload.","uploadOne":"Uploaden bestand ({percentage}%)…","uploadMany":"Bestanden aan het uploaden, {current} van {max} klaar ({percentage}%)…"},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Broncode","searchCode":"Zoek in broncode","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Formatteer selectie","commentSelectedRange":"Zet selectie in commentaar","uncommentSelectedRange":"Haal selectie uit commentaar","autoCompleteToggle":"Zet automatisch aanvullen van HTML tags aan/uit"},"emoji":{"searchPlaceholder":"Zoek emoji…","searchLabel":"Invoerveld verantwoordelijk voor het zoeken en filteren van emoji's in het paneel.","navigationLabel":"Groepsnavigatie voor emoji-secties.","title":"Emoji Lijst","groups":{"people":"Mensen","nature":"Natuur en dieren","food":"Eten en drinken","travel":"Reizen en plaatsen","activities":"Activiteiten","objects":"Objecten","symbols":"Symbolen","flags":"Vlaggen"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Broncode","title":"Broncode"}};