﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['ko']={"application":"Rich Text Editor","editor":"리치 텍스트 편집기","editorPanel":"리치 텍스트 편집기 패널","common":{"editorHelp":"도움이 필요하면 ALT 0 을 누르세요","browseServer":"서버 탐색","url":"URL","protocol":"프로토콜","upload":"업로드","uploadSubmit":"서버로 전송","image":"이미지","form":"폼","checkbox":"체크 박스","radio":"라디오 버튼","textField":"한 줄 입력 칸","textarea":"여러 줄 입력 칸","hiddenField":"숨은 입력 칸","button":"버튼","select":"선택 목록","imageButton":"이미지 버튼","notSet":"<설정 안 됨>","id":"ID","name":"이름","langDir":"언어 방향","langDirLtr":"왼쪽에서 오른쪽 (LTR)","langDirRtl":"오른쪽에서 왼쪽 (RTL)","langCode":"언어 코드","longDescr":"웹 주소 설명","cssClass":"스타일 시트 클래스","advisoryTitle":"보조 제목","cssStyle":"스타일","ok":"확인","cancel":"취소","close":"닫기","preview":"미리보기","resize":"크기 조절","generalTab":"일반","advancedTab":"자세히","validateNumberFailed":"이 값은 숫자가 아닙니다.","confirmNewPage":"저장하지 않은 모든 변경사항은 유실됩니다. 정말로 새로운 페이지를 부르겠습니까?","confirmCancel":"일부 옵션이 변경 되었습니다. 정말로 창을 닫겠습니까?","options":"옵션","target":"타겟","targetNew":"새 창 (_blank)","targetTop":"최상위 창 (_top)","targetSelf":"같은 창 (_self)","targetParent":"부모 창 (_parent)","langDirLTR":"왼쪽에서 오른쪽 (LTR)","langDirRTL":"오른쪽에서 왼쪽 (RTL)","styles":"스타일","cssClasses":"스타일 시트 클래스","width":"너비","height":"높이","align":"정렬","left":"왼쪽","right":"오른쪽","center":"중앙","justify":"양쪽 정렬","alignLeft":"왼쪽 정렬","alignRight":"오른쪽 정렬","alignCenter":"중앙 정렬","alignTop":"위","alignMiddle":"중간","alignBottom":"아래","alignNone":"기본","invalidValue":"잘못된 값.","invalidHeight":"높이는 숫자여야 합니다.","invalidWidth":"넓이는 숫자여야 합니다.","invalidLength":"\"%1\" 값은 유효한 측정단위(%2)를 포함하거나 포함하지 않은 양수여야 합니다.","invalidCssLength":"\"%1\" 값은 유효한 CSS 측정 단위(px, %, in, cm, mm, em, ex, pt, or pc)를 포함하거나 포함하지 않은 양수 여야 합니다.","invalidHtmlLength":"\"%1\" 값은 유효한 HTML 측정 단위(px or %)를 포함하거나 포함하지 않은 양수여야 합니다.","invalidInlineStyle":"인라인 스타일에 명시된 값은 세미콜론(;)으로 구분되는 한 쌍 이상의 \"이름 : 값\" 형식으로 구성되어야 합니다.","cssLengthTooltip":"픽셀 단위의 숫자만 입력하시거나 숫자와 유효한 CSS 단위(px, %, in, cm, mm, em, ex, pt, or pc)를 함께 입력해주세요.","unavailable":"%1<span class=\"cke_accessibility\">, 사용불가</span>","keyboard":{"8":"백스페이스","13":"엔터","16":"시프트","17":"컨트롤","18":"알트","32":"간격","35":"엔드","36":"홈","46":"딜리트","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"커맨드"},"keyboardShortcut":"키보드 단축키","optionDefault":"기본값"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"저작권 &copy; $1 . 판권 소유.","dlgTitle":"CKEditor 에 대하여","moreInfo":"라이선스에 대한 정보는 저희 웹 사이트를 참고하세요:"},"basicstyles":{"bold":"굵게","italic":"기울임꼴","strike":"취소선","subscript":"아래 첨자","superscript":"위 첨자","underline":"밑줄"},"bidi":{"ltr":"텍스트 방향이 왼쪽에서 오른쪽으로 ","rtl":"텍스트 방향이 오른쪽에서 왼쪽으로"},"blockquote":{"toolbar":"인용 단락"},"notification":{"closed":"알림이 닫힘."},"toolbar":{"toolbarCollapse":"툴바 줄이기","toolbarExpand":"툴바 확장","toolbarGroups":{"document":"문서","clipboard":"클립보드/실행 취소","editing":"편집","forms":"폼","basicstyles":"기본 스타일","paragraph":"단락","links":"링크","insert":"삽입","styles":"스타일","colors":"색상","tools":"도구"},"toolbars":"에디터 툴바"},"clipboard":{"copy":"복사","copyError":"브라우저의 보안설정 때문에 복사할 수 없습니다. 키보드(Ctrl/Cmd+C)를 이용해서 복사하십시오.","cut":"잘라내기","cutError":"브라우저의 보안설정 때문에 잘라내기 기능을 실행할 수 없습니다. 키보드(Ctrl/Cmd+X)를 이용해서 잘라내기 하십시오","paste":"붙여넣기","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","pasteArea":"붙여넣기 범위","pasteMsg":"Paste your content inside the area below and press OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"기본 색상","bgColorTitle":"배경 색상","colors":{"000":"검정","800000":"밤색","8B4513":"새들 브라운","2F4F4F":"다크 슬레이트 그레이","008080":"틸","000080":"네이비","4B0082":"남색","696969":"짙은 회색","B22222":"벽돌색","A52A2A":"갈색","DAA520":"골든 로드","006400":"암록색","40E0D0":"터코이즈","0000CD":"미디엄 블루","800080":"보라","808080":"회색","F00":"빨강","FF8C00":"짙은 주황","FFD700":"금색","008000":"녹색","0FF":"시안","00F":"파랑","EE82EE":"남보라","A9A9A9":"딤 그레이","FFA07A":"라이트 새먼","FFA500":"주황","FFFF00":"노랑","00FF00":"라임","AFEEEE":"패일 터코이즈","ADD8E6":"연한 파랑","DDA0DD":"자두","D3D3D3":"연한 회색","FFF0F5":"라벤더 블러쉬","FAEBD7":"앤틱 화이트","FFFFE0":"연한 노랑","F0FFF0":"허니듀","F0FFFF":"하늘색","F0F8FF":"앨리스 블루","E6E6FA":"라벤더","FFF":"흰색","1ABC9C":"진한 청록색","2ECC71":"에메랄드","3498DB":"밝은 파랑","9B59B6":"자수정","4E5F70":"회청색","F1C40F":"선명한 노랑","16A085":"다크 시안","27AE60":"다크 에메랄드","2980B9":"진한 파랑","8E44AD":"다크 바이올렛","2C3E50":"탁한 파랑","F39C12":"주황","E67E22":"당근","E74C3C":"창백한 빨강","ECF0F1":"밝은 은색","95A5A6":"밝은 회청록","DDD":"밝은 회색","D35400":"호박","C0392B":"진한 빨강","BDC3C7":"은색","7F8C8D":"회청록","999":"암회색"},"more":"색상 선택...","panelTitle":"색상","textColorTitle":"글자 색상"},"colordialog":{"clear":"비우기","highlight":"강조","options":"색상 옵션","selected":"선택된 색상","title":"색상 선택"},"templates":{"button":"템플릿","emptyListMsg":"(템플릿이 없습니다)","insertOption":"현재 내용 바꾸기","options":"템플릿 옵션","selectPromptMsg":"에디터에서 사용할 템플릿을 선택하십시오","title":"내용 템플릿"},"contextmenu":{"options":"컨텍스트 메뉴 옵션"},"copyformatting":{"label":"양식 복사","notification":{"copied":"양식이 복사 되었습니다","applied":"양식을 적용 했습니다","canceled":"양식이 취소 되었습니다","failed":"양식 적용에 실패했습니다. 양식을 복사해야 적용할 수 있습니다."}},"div":{"IdInputLabel":"ID","advisoryTitleInputLabel":"보조 제목","cssClassInputLabel":"스타일 시트 클래스","edit":"Div 편집","inlineStyleInputLabel":"인라인 스타일","langDirLTRLabel":"왼쪽에서 오른쪽 (LTR)","langDirLabel":"언어 방향","langDirRTLLabel":"오른쪽에서 왼쪽 (RTL)","languageCodeInputLabel":" 언어 코드","remove":"Div 태그 삭제","styleSelectLabel":"스타일","title":"Div 태그 생성","toolbar":"Div 태그 생성"},"elementspath":{"eleLabel":"요소 경로","eleTitle":"%1 요소"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"파일을 읽는 중 오류가 발생했습니다.","networkError":"파일 업로드 중 네트워크 오류가 발생했습니다.","httpError404":"파일 업로드중 HTTP 오류가 발생했습니다 (404: 파일 찾을수 없음).","httpError403":"파일 업로드중 HTTP 오류가 발생했습니다 (403: 권한 없음).","httpError":"파일 업로드중 HTTP 오류가 발생했습니다 (오류 코드 %1).","noUrlError":"업로드 주소가 정의되어 있지 않습니다.","responseError":"잘못된 서버 응답."},"find":{"find":"찾기","findOptions":"찾기 조건","findWhat":"찾을 내용:","matchCase":"대소문자 구분","matchCyclic":"되돌이 검색","matchWord":"온전한 단어","notFoundMsg":"문자열을 찾을 수 없습니다.","replace":"바꾸기","replaceAll":"모두 바꾸기","replaceSuccessMsg":"%1개의 항목이 바뀌었습니다.","replaceWith":"바꿀 내용:","title":"찾기 및 바꾸기"},"font":{"fontSize":{"label":"크기","voiceLabel":"글자 크기","panelTitle":"글자 크기"},"label":"글꼴","panelTitle":"글꼴","voiceLabel":"글꼴"},"fakeobjects":{"anchor":"책갈피","hiddenfield":"숨은 입력 칸","iframe":"아이프레임","unknown":"알 수 없는 객체"},"forms":{"button":{"title":"버튼 속성","text":"글자 (값)","type":"종류","typeBtn":"버튼","typeSbm":"제출","typeRst":"재설정"},"checkboxAndRadio":{"checkboxTitle":"체크 박스 속성","radioTitle":"라디오 버튼 속성","value":"값","selected":"선택됨","required":"필수 항목"},"form":{"title":"폼 속성","menu":"폼 속성","action":"실행 경로(Action)","method":"방법(Method)","encoding":"인코딩"},"hidden":{"title":"숨은 입력 칸 속성","name":"이름","value":"값"},"select":{"title":"선택 목록 속성","selectInfo":"선택 정보","opAvail":"옵션","value":"값","size":"크기","lines":"줄","chkMulti":"여러 항목 선택 허용","required":"필수 항목","opText":"이름","opValue":"값","btnAdd":"추가","btnModify":"수정","btnUp":"위","btnDown":"아래","btnSetValue":"선택된 것으로 설정","btnDelete":"삭제"},"textarea":{"title":"여러 줄 입력 칸 속성","cols":"칸 수","rows":"줄 수"},"textfield":{"title":"한 줄 입력 칸 속성","name":"이름","value":"값","charWidth":"글자 너비","maxChars":"최대 글자 수","required":"필수 항목","type":"형식","typeText":"문자열","typePass":"비밀번호","typeEmail":"이메일","typeSearch":"검색","typeTel":"전화번호","typeUrl":"웹 주소(URL)"}},"format":{"label":"문단","panelTitle":"문단 형식","tag_address":"글쓴이","tag_div":"기본 (DIV)","tag_h1":"제목 1","tag_h2":"제목 2","tag_h3":"제목 3","tag_h4":"제목 4","tag_h5":"제목 5","tag_h6":"제목 6","tag_p":"본문","tag_pre":"정형 문단"},"horizontalrule":{"toolbar":"가로 줄 삽입"},"iframe":{"border":"프레임 테두리 표시","noUrl":"아이프레임 주소(URL)를 입력해주세요.","scrolling":"스크롤바 사용","title":"아이프레임 속성","toolbar":"아이프레임","tabindex":"Remove from tabindex"},"image":{"alt":"대체 문자열","border":"테두리","btnUpload":"서버로 전송","button2Img":"단순 이미지에서 선택한 이미지 버튼을 변환하시겠습니까?","hSpace":"가로 여백","img2Button":"이미지 버튼에 선택한 이미지를 변환하시겠습니까?","infoTab":"이미지 정보","linkTab":"링크","lockRatio":"비율 유지","menu":"이미지 속성","resetSize":"원래 크기로","title":"이미지 속성","titleButton":"이미지 버튼 속성","upload":"업로드","urlMissing":"이미지 원본 주소(URL)가 없습니다.","vSpace":"세로 여백","validateBorder":"테두리 두께는 정수여야 합니다.","validateHSpace":"가로 길이는 정수여야 합니다.","validateVSpace":"세로 길이는 정수여야 합니다."},"indent":{"indent":"들여쓰기","outdent":"내어쓰기"},"smiley":{"options":"이모티콘 옵션","title":"이모티콘 삽입","toolbar":"이모티콘"},"language":{"button":"언어 설정","remove":"언어 설정 지우기"},"link":{"acccessKey":"액세스 키","advanced":"고급","advisoryContentType":"보조 콘텐츠 유형","advisoryTitle":"보조 제목","anchor":{"toolbar":"책갈피","menu":"책갈피 편집","title":"책갈피 속성","name":"책갈피 이름","errorName":"책갈피 이름을 입력하십시오","errorWhitespace":"Anchor name cannot contain space characters","remove":"책갈피 제거"},"anchorId":"책갈피 ID","anchorName":"책갈피 이름","charset":"링크된 자료 문자열 인코딩","cssClasses":"스타일시트 클래스","download":"강제 다운로드","displayText":"보이는 글자","emailAddress":"이메일 주소","emailBody":"메시지 내용","emailSubject":"메시지 제목","id":"ID","info":"링크 정보","langCode":"언어 코드","langDir":"언어 방향","langDirLTR":"왼쪽에서 오른쪽 (LTR)","langDirRTL":"오른쪽에서 왼쪽 (RTL)","menu":"링크 수정","name":"이름","noAnchors":"(문서에 책갈피가 없습니다.)","noEmail":"이메일 주소를 입력하십시오","noUrl":"링크 주소(URL)를 입력하십시오","noTel":"Please type the phone number","other":"<기타>","phoneNumber":"Phone number","popupDependent":"Dependent (Netscape)","popupFeatures":"팝업창 속성","popupFullScreen":"전체화면 (IE)","popupLeft":"왼쪽 위치","popupLocationBar":"주소 표시줄","popupMenuBar":"메뉴 바","popupResizable":"크기 조절 가능","popupScrollBars":"스크롤 바","popupStatusBar":"상태 바","popupToolbar":"툴바","popupTop":"위쪽 위치","rel":"관계","selectAnchor":"책갈피 선택","styles":"스타일","tabIndex":"탭 순서","target":"타겟","targetFrame":"<프레임>","targetFrameName":"타겟 프레임 이름","targetPopup":"<팝업 창>","targetPopupName":"팝업 창 이름","title":"링크","toAnchor":"책갈피","toEmail":"이메일","toUrl":"주소(URL)","toPhone":"Phone","toolbar":"링크 삽입/변경","type":"링크 종류","unlink":"링크 지우기","upload":"업로드"},"list":{"bulletedlist":"순서 없는 목록","numberedlist":"순서 있는 목록"},"liststyle":{"bulletedTitle":"순서 없는 목록 속성","circle":"원","decimal":"수 (1, 2, 3, 등)","disc":"내림차순","lowerAlpha":"영소문자 (a, b, c, d, e, 등)","lowerRoman":"로마 소문자 (i, ii, iii, iv, v, 등)","none":"없음","notset":"<설정 없음>","numberedTitle":"순서 있는 목록 속성","square":"사각","start":"시작","type":"유형","upperAlpha":"영대문자 (A, B, C, D, E, 등)","upperRoman":"로마 대문자 (I, II, III, IV, V, 등)","validateStartNumber":"목록 시작 숫자는 정수여야 합니다."},"magicline":{"title":"여기에 단락 삽입"},"maximize":{"maximize":"최대화","minimize":"최소화"},"newpage":{"toolbar":"새 페이지"},"pagebreak":{"alt":"페이지 나누기","toolbar":"인쇄시 페이지 나누기 삽입"},"pastetext":{"button":"텍스트로 붙여넣기","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","title":"텍스트로 붙여넣기"},"pastefromword":{"confirmCleanup":"붙여 넣을 내용은 MS Word에서 복사 한 것입니다. 붙여 넣기 전에 정리 하시겠습니까?","error":"내부 오류로 붙여 넣은 데이터를 정리 할 수 없습니다.","title":"MS Word 에서 붙여넣기","toolbar":"MS Word 에서 붙여넣기"},"preview":{"preview":"미리보기"},"print":{"toolbar":"인쇄"},"removeformat":{"toolbar":"형식 지우기"},"save":{"toolbar":"저장"},"selectall":{"toolbar":"모두 선택"},"showblocks":{"toolbar":"블록 보기"},"sourcearea":{"toolbar":"소스"},"specialchar":{"options":"특수문자 옵션","title":"특수문자 선택","toolbar":"특수문자 삽입"},"scayt":{"btn_about":"About SCAYT","btn_dictionaries":"Dictionaries","btn_disable":"Disable SCAYT","btn_enable":"Enable SCAYT","btn_langs":"Languages","btn_options":"Options","text_title":"Spell Check As You Type"},"stylescombo":{"label":"스타일","panelTitle":"전체 구성 스타일","panelTitle1":"블록 스타일","panelTitle2":"인라인 스타일","panelTitle3":"객체 스타일"},"table":{"border":"테두리 두께","caption":"주석","cell":{"menu":"셀","insertBefore":"앞에 셀 삽입","insertAfter":"뒤에 셀 삽입","deleteCell":"셀 삭제","merge":"셀 합치기","mergeRight":"오른쪽 합치기","mergeDown":"왼쪽 합치기","splitHorizontal":"수평 나누기","splitVertical":"수직 나누기","title":"셀 속성","cellType":"셀 종류","rowSpan":"행 간격","colSpan":"열 간격","wordWrap":"줄 끝 단어 줄 바꿈","hAlign":"가로 정렬","vAlign":"세로 정렬","alignBaseline":"영문 글꼴 기준선","bgColor":"배경색","borderColor":"테두리 색","data":"자료","header":"머릿칸","columnHeader":"Column Header","rowHeader":"Row Header","yes":"예","no":"아니오","invalidWidth":"셀 너비는 숫자여야 합니다.","invalidHeight":"셀 높이는 숫자여야 합니다.","invalidRowSpan":"행 간격은 정수여야 합니다.","invalidColSpan":"열 간격은 정수여야 합니다.","chooseColor":"선택"},"cellPad":"셀 여백","cellSpace":"셀 간격","column":{"menu":"열","insertBefore":"왼쪽에 열 삽입","insertAfter":"오른쪽에 열 삽입","deleteColumn":"열 삭제"},"columns":"열","deleteTable":"표 삭제","headers":"머릿칸","headersBoth":"모두","headersColumn":"첫 열","headersNone":"없음","headersRow":"첫 행","heightUnit":"height unit","invalidBorder":"테두리 두께는 숫자여야 합니다.","invalidCellPadding":"셀 여백은 0 이상이어야 합니다.","invalidCellSpacing":"셀 간격은 0 이상이어야 합니다.","invalidCols":"열 번호는 0보다 커야 합니다.","invalidHeight":"표 높이는 숫자여야 합니다.","invalidRows":"행 번호는 0보다 커야 합니다.","invalidWidth":"표의 너비는 숫자여야 합니다.","menu":"표 속성","row":{"menu":"행","insertBefore":"위에 행 삽입","insertAfter":"아래에 행 삽입","deleteRow":"행 삭제"},"rows":"행","summary":"요약","title":"표 속성","toolbar":"표","widthPc":"백분율","widthPx":"픽셀","widthUnit":"너비 단위"},"undo":{"redo":"다시 실행","undo":"실행 취소"},"widget":{"move":"움직이려면 클릭 후 드래그 하세요","label":"%1 위젯"},"uploadwidget":{"abort":"사용자가 업로드를 중단했습니다.","doneOne":"파일이 성공적으로 업로드되었습니다.","doneMany":"파일 %1개를 성공적으로 업로드하였습니다.","uploadOne":"파일 업로드중 ({percentage}%)...","uploadMany":"파일 {max} 개 중 {current} 번째 파일 업로드 중 ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"소스","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Search emoji…","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"Emoji List","groups":{"people":"People","nature":"Nature and animals","food":"Food and drinks","travel":"Travel and places","activities":"Activities","objects":"Objects","symbols":"Symbols","flags":"Flags"}},"html5video":{"button":"HTML5 비디오 추가하기","title":"HTML5 비디오","infoLabel":"비디오 정보","allowed":"허용된 파일 확장자들: MP4, WebM, Ogv","urlMissing":"비디오 Url이 없습니다.","videoProperties":"비디오 속성","upload":"업로드","btnUpload":"서버로 전송","advanced":"고급","autoplay":"자동재생?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"네","no":"아니오","loop":"무한반복?","responsive":"반응형 너비","controls":"컨트롤 보여주기","poster":"썸네일"},"sourcedialog":{"toolbar":"소스","title":"소스"}};