﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['hu']={"application":"Rich Text Editor","editor":"HTML szerkesztő","editorPanel":"HTML szerkesztő panel","common":{"editorHelp":"Segítségért nyomjon ALT 0-t","browseServer":"Böngészés a szerveren","url":"Hivatkozás","protocol":"Protokoll","upload":"Feltöltés","uploadSubmit":"Küldés a szerverre","image":"Kép","form":"Űrlap","checkbox":"Jelölőnégyzet","radio":"Választógomb","textField":"Szövegmező","textarea":"Szövegterület","hiddenField":"Rejtett mező","button":"Gomb","select":"Legördülő lista","imageButton":"Képgomb","notSet":"<nincs beállítva>","id":"Azonosító","name":"Név","langDir":"Írás iránya","langDirLtr":"Balról jobbra","langDirRtl":"Jobbról balra","langCode":"Nyelv kódja","longDescr":"Részletes leírás webcíme","cssClass":"CSS osztályok","advisoryTitle":"Súgócimke","cssStyle":"Stílus","ok":"Rendben","cancel":"Mégsem","close":"Bezárás","preview":"Előnézet","resize":"Húzza az átméretezéshez","generalTab":"Általános","advancedTab":"Speciális","validateNumberFailed":"A mezőbe csak számokat írhat.","confirmNewPage":"Minden nem mentett változás el fog veszni! Biztosan be szeretné tölteni az oldalt?","confirmCancel":"Pár beállítást megváltoztatott. Biztosan be szeretné zárni az ablakot?","options":"Beállítások","target":"Cél","targetNew":"Új ablak (_blank)","targetTop":"Legfelső ablak (_top)","targetSelf":"Aktuális ablakban (_self)","targetParent":"Szülő ablak (_parent)","langDirLTR":"Balról jobbra (LTR)","langDirRTL":"Jobbról balra (RTL)","styles":"Stílus","cssClasses":"Stíluslap osztály","width":"Szélesség","height":"Magasság","align":"Igazítás","left":"Bal","right":"Jobbra","center":"Középre","justify":"Sorkizárt","alignLeft":"Balra","alignRight":"Jobbra","alignCenter":"Középre igazítás","alignTop":"Tetejére","alignMiddle":"Középre","alignBottom":"Aljára","alignNone":"Semmi","invalidValue":"Érvénytelen érték.","invalidHeight":"A magasság mezőbe csak számokat írhat.","invalidWidth":"A szélesség mezőbe csak számokat írhat.","invalidLength":"A megadott értéknek a \"%1\" mezőben pozitív számnak kell lennie, egy érvényes mértékegységgel vagy anélkül (%2).","invalidCssLength":"\"%1\"-hez megadott érték csakis egy pozitív szám lehet, esetleg egy érvényes CSS egységgel megjelölve(px, %, in, cm, mm, em, ex, pt vagy pc).","invalidHtmlLength":"\"%1\"-hez megadott érték csakis egy pozitív szám lehet, esetleg egy érvényes HTML egységgel megjelölve(px vagy %).","invalidInlineStyle":"Az inline stílusnak megadott értéknek tartalmaznia kell egy vagy több rekordot a \"name : value\" formátumban, pontosvesszővel elválasztva.","cssLengthTooltip":"Adjon meg egy számot értéknek pixelekben vagy egy számot érvényes CSS mértékegységben (px, %, in, cm, mm, em, ex, pt, vagy pc).","unavailable":"%1<span class=\"cke_accessibility\">, nem elérhető</span>","keyboard":{"8":"Backspace","13":"Enter","16":"Shift","17":"Ctrl","18":"Alt","32":"Space","35":"End","36":"Home","46":"Delete","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Command"},"keyboardShortcut":"Gyorsbillentyű","optionDefault":"Alapértelmezett"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Minden jog fenntartva.","dlgTitle":"A CKEditor 4-ről","moreInfo":"Licenszelési információkért kérjük látogassa meg weboldalunkat:"},"basicstyles":{"bold":"Félkövér","italic":"Dőlt","strike":"Áthúzott","subscript":"Alsó index","superscript":"Felső index","underline":"Aláhúzott"},"bidi":{"ltr":"Szöveg iránya balról jobbra","rtl":"Szöveg iránya jobbról balra"},"blockquote":{"toolbar":"Idézet blokk"},"notification":{"closed":"Értesítés bezárva."},"toolbar":{"toolbarCollapse":"Eszköztár összecsukása","toolbarExpand":"Eszköztár szétnyitása","toolbarGroups":{"document":"Dokumentum","clipboard":"Vágólap/Visszavonás","editing":"Szerkesztés","forms":"Űrlapok","basicstyles":"Alapstílusok","paragraph":"Bekezdés","links":"Hivatkozások","insert":"Beszúrás","styles":"Stílusok","colors":"Színek","tools":"Eszközök"},"toolbars":"Szerkesztő Eszköztár"},"clipboard":{"copy":"Másolás","copyError":"A böngésző biztonsági beállításai nem engedélyezik a szerkesztőnek, hogy végrehajtsa a másolás műveletet. Használja az alábbi billentyűkombinációt (Ctrl/Cmd+X).","cut":"Kivágás","cutError":"A böngésző biztonsági beállításai nem engedélyezik a szerkesztőnek, hogy végrehajtsa a kivágás műveletet. Használja az alábbi billentyűkombinációt (Ctrl/Cmd+X).","paste":"Beillesztés","pasteNotification":"Nyomja meg a %1 gombot a beillesztéshez. A böngésző nem támogatja a beillesztést az eszköztárról vagy a menüből.","pasteArea":"Beillesztési terület","pasteMsg":"Illessze be a tartalmat az alábbi mezőbe, és nyomja meg az OK-t.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automatikus","bgColorTitle":"Háttérszín","colors":{"000":"Fekete","800000":"Bordó","8B4513":"Barna","2F4F4F":"Sötét türkiz","008080":"Türkiz","000080":"Király kék","4B0082":"Indigó kék","696969":"Szürke","B22222":"Tégla vörös","A52A2A":"Vörös","DAA520":"Arany sárga","006400":"Sötét zöld","40E0D0":"Türkiz","0000CD":"Kék","800080":"Lila","808080":"Szürke","F00":"Piros","FF8C00":"Sötét narancs","FFD700":"Arany","008000":"Zöld","0FF":"Türkiz","00F":"Kék","EE82EE":"Rózsaszín","A9A9A9":"Sötét szürke","FFA07A":"Lazac","FFA500":"Narancs","FFFF00":"Citromsárga","00FF00":"Neon zöld","AFEEEE":"Világos türkiz","ADD8E6":"Világos kék","DDA0DD":"Világos lila","D3D3D3":"Világos szürke","FFF0F5":"Lavender Blush","FAEBD7":"Törtfehér","FFFFE0":"Világos sárga","F0FFF0":"Menta","F0FFFF":"Azúr kék","F0F8FF":"Halvány kék","E6E6FA":"Lavender","FFF":"Fehér","1ABC9C":"Erős cián","2ECC71":"Smaragd","3498DB":"Fényes kék","9B59B6":"Ametiszt","4E5F70":"Szürkéskék","F1C40F":"Világossárga","16A085":"Sötét cián","27AE60":"Sötét smaragd","2980B9":"Erős kék","8E44AD":"Sötétlila","2C3E50":"Világoskék","F39C12":"Narancs","E67E22":"Répa","E74C3C":"Sápadt vörös","ECF0F1":"Fényes ezüst","95A5A6":"Világos szürkés cián","DDD":"Világosszürke","D35400":"Tök","C0392B":"Erős vörös","BDC3C7":"Ezüst","7F8C8D":"Szürkés cián","999":"Sötétszürke"},"more":"További színek...","panelTitle":"Színek","textColorTitle":"Betűszín"},"colordialog":{"clear":"Ürítés","highlight":"Nagyítás","options":"Szín opciók","selected":"Kiválasztott","title":"Válasszon színt"},"templates":{"button":"Sablonok","emptyListMsg":"(Nincs sablon megadva)","insertOption":"Kicseréli a jelenlegi tartalmat","options":"Sablon opciók","selectPromptMsg":"Válassza ki melyik sablon nyíljon meg a szerkesztőben<br>(a jelenlegi tartalom elveszik):","title":"Elérhető sablonok"},"contextmenu":{"options":"Helyi menü opciók"},"copyformatting":{"label":"Formázás másolása","notification":{"copied":"Formázás másolva","applied":"Formázás alkalmazva","canceled":"Formázás megszakítva","failed":"A formázás meghiúsult. Nem alkalmazhatsz stílusokat mielőtt másolnád őket."}},"div":{"IdInputLabel":"Azonosító","advisoryTitleInputLabel":"Tipp szöveg","cssClassInputLabel":"Stíluslap osztály","edit":"DIV szerkesztése","inlineStyleInputLabel":"Inline stílus","langDirLTRLabel":"Balról jobbra (LTR)","langDirLabel":"Nyelvi irány","langDirRTLLabel":"Jobbról balra (RTL)","languageCodeInputLabel":" Nyelv kódja","remove":"DIV eltávolítása","styleSelectLabel":"Stílus","title":"DIV tároló létrehozása","toolbar":"DIV tároló létrehozása"},"elementspath":{"eleLabel":"Elem utak","eleTitle":"%1 elem"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Hiba történt a fájl olvasása közben.","networkError":"Hálózati hiba történt a fájl feltöltése közben.","httpError404":"HTTP hiba történt a fájl feltöltése alatt (404: A fájl nem található).","httpError403":"HTTP hiba történt a fájl feltöltése alatt (403: Tiltott).","httpError":"HTTP hiba történt a fájl feltöltése alatt (hiba státusz: %1).","noUrlError":"Feltöltési URL nincs megadva.","responseError":"Helytelen szerver válasz."},"find":{"find":"Keresés","findOptions":"Beállítások","findWhat":"Keresett szöveg:","matchCase":"Kis- és nagybetű megkülönböztetése","matchCyclic":"Ciklikus keresés","matchWord":"Csak ha ez a teljes szó","notFoundMsg":"A keresett szöveg nem található.","replace":"Csere","replaceAll":"Az összes cseréje","replaceSuccessMsg":"%1 egyezőség cserélve.","replaceWith":"Csere erre:","title":"Keresés és csere"},"font":{"fontSize":{"label":"Méret","voiceLabel":"Betűméret","panelTitle":"Méret"},"label":"Betűtípus","panelTitle":"Betűtípus","voiceLabel":"Betűtípus"},"fakeobjects":{"anchor":"Horgony","hiddenfield":"Rejtett mezõ","iframe":"IFrame","unknown":"Ismeretlen objektum"},"forms":{"button":{"title":"Gomb tulajdonságai","text":"Szöveg (Érték)","type":"Típus","typeBtn":"Gomb","typeSbm":"Küldés","typeRst":"Alaphelyzet"},"checkboxAndRadio":{"checkboxTitle":"Jelölőnégyzet tulajdonságai","radioTitle":"Választógomb tulajdonságai","value":"Érték","selected":"Kiválasztott","required":"Kötelező"},"form":{"title":"Űrlap tulajdonságai","menu":"Űrlap tulajdonságai","action":"Adatfeldolgozást végző hivatkozás","method":"Adatküldés módja","encoding":"Kódolás"},"hidden":{"title":"Rejtett mező tulajdonságai","name":"Név","value":"Érték"},"select":{"title":"Legördülő lista tulajdonságai","selectInfo":"Alaptulajdonságok","opAvail":"Elérhető opciók","value":"Érték","size":"Méret","lines":"sor","chkMulti":"több sor is kiválasztható","required":"Kötelező","opText":"Szöveg","opValue":"Érték","btnAdd":"Hozzáad","btnModify":"Módosít","btnUp":"Fel","btnDown":"Le","btnSetValue":"Legyen az alapértelmezett érték","btnDelete":"Töröl"},"textarea":{"title":"Szövegterület tulajdonságai","cols":"Karakterek száma egy sorban","rows":"Sorok száma"},"textfield":{"title":"Szövegmező tulajdonságai","name":"Név","value":"Érték","charWidth":"Megjelenített karakterek száma","maxChars":"Maximális karakterszám","required":"Kötelező","type":"Típus","typeText":"Szöveg","typePass":"Jelszó","typeEmail":"Ímél","typeSearch":"Keresés","typeTel":"Telefonszám","typeUrl":"URL"}},"format":{"label":"Formátum","panelTitle":"Bekezdés formátum","tag_address":"Címsor","tag_div":"Bekezdés (DIV)","tag_h1":"Fejléc 1","tag_h2":"Fejléc 2","tag_h3":"Fejléc 3","tag_h4":"Fejléc 4","tag_h5":"Fejléc 5","tag_h6":"Fejléc 6","tag_p":"Normál","tag_pre":"Formázott"},"horizontalrule":{"toolbar":"Elválasztóvonal beillesztése"},"iframe":{"border":"Legyen keret","noUrl":"Kérem írja be a iframe URL-t","scrolling":"Gördítősáv bekapcsolása","title":"IFrame Tulajdonságok","toolbar":"IFrame","tabindex":"Eltávolítás a tabindexből"},"image":{"alt":"Alternatív szöveg","border":"Keret","btnUpload":"Küldés a szerverre","button2Img":"Szeretne a kiválasztott képgombból sima képet csinálni?","hSpace":"Vízsz. táv","img2Button":"Szeretne a kiválasztott képből képgombot csinálni?","infoTab":"Alaptulajdonságok","linkTab":"Hivatkozás","lockRatio":"Arány megtartása","menu":"Kép tulajdonságai","resetSize":"Eredeti méret","title":"Kép tulajdonságai","titleButton":"Képgomb tulajdonságai","upload":"Feltöltés","urlMissing":"Hiányzik a kép URL-je.","vSpace":"Függ. táv","validateBorder":"A keret méretének egész számot kell beírni!","validateHSpace":"Vízszintes távolságnak egész számot kell beírni!","validateVSpace":"Függőleges távolságnak egész számot kell beírni!"},"indent":{"indent":"Behúzás növelése","outdent":"Behúzás csökkentése"},"smiley":{"options":"Hangulatjel opciók","title":"Hangulatjel beszúrása","toolbar":"Hangulatjelek"},"language":{"button":"Nyelv beállítása","remove":"Nyelv eltávolítása"},"link":{"acccessKey":"Billentyűkombináció","advanced":"További opciók","advisoryContentType":"Súgó tartalomtípusa","advisoryTitle":"Súgócimke","anchor":{"toolbar":"Horgony beillesztése/szerkesztése","menu":"Horgony tulajdonságai","title":"Horgony tulajdonságai","name":"Horgony neve","errorName":"Kérem adja meg a horgony nevét","errorWhitespace":"Anchor name cannot contain space characters","remove":"Horgony eltávolítása"},"anchorId":"Azonosító szerint","anchorName":"Horgony név szerint","charset":"Hivatkozott tartalom kódlapja","cssClasses":"Stíluskészlet","download":"Kötelező letöltés","displayText":"Megjelenített szöveg","emailAddress":"E-Mail cím","emailBody":"Üzenet","emailSubject":"Üzenet tárgya","id":"Id","info":"Alaptulajdonságok","langCode":"Írás iránya","langDir":"Írás iránya","langDirLTR":"Balról jobbra","langDirRTL":"Jobbról balra","menu":"Hivatkozás módosítása","name":"Név","noAnchors":"(Nincs horgony a dokumentumban)","noEmail":"Adja meg az E-Mail címet","noUrl":"Adja meg a hivatkozás webcímét","noTel":"Adja meg a telefonszámot","other":"<más>","phoneNumber":"Telefonszám","popupDependent":"Szülőhöz kapcsolt (csak Netscape)","popupFeatures":"Felugró ablak jellemzői","popupFullScreen":"Teljes képernyő (csak IE)","popupLeft":"Bal pozíció","popupLocationBar":"Címsor","popupMenuBar":"Menü sor","popupResizable":"Átméretezés","popupScrollBars":"Gördítősáv","popupStatusBar":"Állapotsor","popupToolbar":"Eszköztár","popupTop":"Felső pozíció","rel":"Kapcsolat típusa","selectAnchor":"Horgony választása","styles":"Stílus","tabIndex":"Tabulátor index","target":"Tartalom megjelenítése","targetFrame":"<keretben>","targetFrameName":"Keret neve","targetPopup":"<felugró ablakban>","targetPopupName":"Felugró ablak neve","title":"Hivatkozás tulajdonságai","toAnchor":"Horgony az oldalon","toEmail":"E-Mail","toUrl":"URL","toPhone":"Telefon","toolbar":"Hivatkozás beillesztése/módosítása","type":"Hivatkozás típusa","unlink":"Hivatkozás törlése","upload":"Feltöltés"},"list":{"bulletedlist":"Felsorolás","numberedlist":"Számozás"},"liststyle":{"bulletedTitle":"Pontozott lista tulajdonságai","circle":"Kör","decimal":"Arab számozás (1, 2, 3, stb.)","disc":"Korong","lowerAlpha":"Kisbetűs (a, b, c, d, e, stb.)","lowerRoman":"Római kisbetűs (i, ii, iii, iv, v, stb.)","none":"Nincs","notset":"<Nincs beállítva>","numberedTitle":"Sorszámozott lista tulajdonságai","square":"Négyzet","start":"Kezdőszám","type":"Típus","upperAlpha":"Nagybetűs (A, B, C, D, E, stb.)","upperRoman":"Római nagybetűs (I, II, III, IV, V, stb.)","validateStartNumber":"A kezdőszám nem lehet tört érték."},"magicline":{"title":"Szúrja be a bekezdést ide"},"maximize":{"maximize":"Teljes méret","minimize":"Kis méret"},"newpage":{"toolbar":"Új oldal"},"pagebreak":{"alt":"Oldaltörés","toolbar":"Oldaltörés beillesztése"},"pastetext":{"button":"Beillesztés formázatlan szövegként","pasteNotification":"Nyomja meg a %1 gombot a beillesztéshez. A böngésző nem támogatja a beillesztést az eszköztár gombbal vagy a menüből.","title":"Beillesztés formázatlan szövegként"},"pastefromword":{"confirmCleanup":"Úgy tűnik a beillesztett szöveget Word-ből másolta át. Meg szeretné tisztítani a szöveget? (ajánlott)","error":"Egy belső hiba miatt nem sikerült megtisztítani a szöveget","title":"Beillesztés Word-ből","toolbar":"Beillesztés Word-ből"},"preview":{"preview":"Előnézet"},"print":{"toolbar":"Nyomtatás"},"removeformat":{"toolbar":"Formázás eltávolítása"},"save":{"toolbar":"Mentés"},"selectall":{"toolbar":"Mindent kijelöl"},"showblocks":{"toolbar":"Blokkok megjelenítése"},"sourcearea":{"toolbar":"Forráskód"},"specialchar":{"options":"Speciális karakter opciók","title":"Speciális karakter választása","toolbar":"Speciális karakter beillesztése"},"scayt":{"btn_about":"SCAYT névjegy","btn_dictionaries":"Szótár","btn_disable":"SCAYT letiltása","btn_enable":"SCAYT engedélyezése","btn_langs":"Nyelvek","btn_options":"Beállítások","text_title":"Helyesírás ellenőrzés gépelés közben"},"stylescombo":{"label":"Stílus","panelTitle":"Formázási stílusok","panelTitle1":"Blokk stílusok","panelTitle2":"Inline stílusok","panelTitle3":"Objektum stílusok"},"table":{"border":"Szegélyméret","caption":"Felirat","cell":{"menu":"Cella","insertBefore":"Beszúrás balra","insertAfter":"Beszúrás jobbra","deleteCell":"Cellák törlése","merge":"Cellák egyesítése","mergeRight":"Cellák egyesítése jobbra","mergeDown":"Cellák egyesítése lefelé","splitHorizontal":"Cellák szétválasztása vízszintesen","splitVertical":"Cellák szétválasztása függőlegesen","title":"Cella tulajdonságai","cellType":"Cella típusa","rowSpan":"Függőleges egyesítés","colSpan":"Vízszintes egyesítés","wordWrap":"Hosszú sorok törése","hAlign":"Vízszintes igazítás","vAlign":"Függőleges igazítás","alignBaseline":"Alapvonalra","bgColor":"Háttér színe","borderColor":"Keret színe","data":"Adat","header":"Fejléc","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Igen","no":"Nem","invalidWidth":"A szélesség mezőbe csak számokat írhat.","invalidHeight":"A magasság mezőbe csak számokat írhat.","invalidRowSpan":"A függőleges egyesítés mezőbe csak számokat írhat.","invalidColSpan":"A vízszintes egyesítés mezőbe csak számokat írhat.","chooseColor":"Válasszon"},"cellPad":"Cella belső margó","cellSpace":"Cella térköz","column":{"menu":"Oszlop","insertBefore":"Beszúrás balra","insertAfter":"Beszúrás jobbra","deleteColumn":"Oszlopok törlése"},"columns":"Oszlopok","deleteTable":"Táblázat törlése","headers":"Fejlécek","headersBoth":"Mindkettő","headersColumn":"Első oszlop","headersNone":"Nincsenek","headersRow":"Első sor","heightUnit":"Magasság egység","invalidBorder":"A szegélyméret mezőbe csak számokat írhat.","invalidCellPadding":"A cella belső margó mezőbe csak számokat írhat.","invalidCellSpacing":"A cella térköz mezőbe csak számokat írhat.","invalidCols":"Az oszlopok számának nagyobbnak kell lenni mint 0.","invalidHeight":"A magasság mezőbe csak számokat írhat.","invalidRows":"A sorok számának nagyobbnak kell lenni mint 0.","invalidWidth":"A szélesség mezőbe csak számokat írhat.","menu":"Táblázat tulajdonságai","row":{"menu":"Sor","insertBefore":"Beszúrás fölé","insertAfter":"Beszúrás alá","deleteRow":"Sorok törlése"},"rows":"Sorok","summary":"Leírás","title":"Táblázat tulajdonságai","toolbar":"Táblázat","widthPc":"százalék","widthPx":"képpont","widthUnit":"Szélesség egység"},"undo":{"redo":"Ismétlés","undo":"Visszavonás"},"widget":{"move":"Kattints és húzd a mozgatáshoz","label":"%1 modul"},"uploadwidget":{"abort":"A feltöltést a felhasználó megszakította.","doneOne":"A fájl sikeresen feltöltve.","doneMany":"%1 fájl sikeresen feltöltve.","uploadOne":"Fájl feltöltése ({percentage}%)...","uploadMany":"Fájlok feltöltése, {current}/{max} kész ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Forráskód","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Emoji keresése...","searchLabel":"A beviteli mezőben kereshetőek és szűrhetőek az emojik a panelban.","navigationLabel":"Csoport navigáció az emoji szekciókhoz.","title":"Emoji lista","groups":{"people":"Emberek","nature":"Természet és állatok","food":"Ételek és italok","travel":"Utazás és helyek","activities":"Tevékenységek","objects":"Tárgyak","symbols":"Szimbólumok","flags":"Zászlók"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Forráskód","title":"Forráskód"}};