﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['es']={"application":"Rich Text Editor","editor":"Editor de Texto Enriquecido","editorPanel":"Panel del Editor de Texto Enriquecido","common":{"editorHelp":"Pulse ALT 0 para ayuda","browseServer":"Ver Servidor","url":"URL","protocol":"Protocolo","upload":"Cargar","uploadSubmit":"Enviar al Servidor","image":"Imagen","form":"Formulario","checkbox":"Casilla de Verificación","radio":"Botones de Radio","textField":"Campo de Texto","textarea":"Area de Texto","hiddenField":"Campo Oculto","button":"Botón","select":"Campo de Selección","imageButton":"Botón Imagen","notSet":"<No definido>","id":"Id","name":"Nombre","langDir":"Orientación","langDirLtr":"Izquierda a Derecha (LTR)","langDirRtl":"Derecha a Izquierda (RTL)","langCode":"Cód. de idioma","longDescr":"Descripción larga URL","cssClass":"Clases de hojas de estilo","advisoryTitle":"Título","cssStyle":"Estilo","ok":"Aceptar","cancel":"Cancelar","close":"Cerrar","preview":"Previsualización","resize":"Arrastre para redimensionar","generalTab":"General","advancedTab":"Avanzado","validateNumberFailed":"El valor no es un número.","confirmNewPage":"Cualquier cambio que no se haya guardado se perderá.\r\n¿Está seguro de querer crear una nueva página?","confirmCancel":"Algunas de las opciones se han cambiado.\r\n¿Está seguro de querer cerrar el diálogo?","options":"Opciones","target":"Destino","targetNew":"Nueva ventana (_blank)","targetTop":"Ventana principal (_top)","targetSelf":"Misma ventana (_self)","targetParent":"Ventana padre (_parent)","langDirLTR":"Izquierda a derecha (LTR)","langDirRTL":"Derecha a izquierda (RTL)","styles":"Estilos","cssClasses":"Clase de la hoja de estilos","width":"Anchura","height":"Altura","align":"Alineación","left":"Izquierda","right":"Derecha","center":"Centrado","justify":"Justificado","alignLeft":"Alinear a Izquierda","alignRight":"Alinear a Derecha","alignCenter":"Centrar","alignTop":"Tope","alignMiddle":"Centro","alignBottom":"Pie","alignNone":"Ninguno","invalidValue":"Valor no válido","invalidHeight":"Altura debe ser un número.","invalidWidth":"Anchura debe ser un número.","invalidLength":"El valor especificado para el campo \"%1\" debe ser un número positivo, incluyendo opcionalmente una unidad de medida válida (%2).","invalidCssLength":"El valor especificado para el campo \"%1\" debe ser un número positivo, incluyendo optionalmente una unidad de medida CSS válida (px, %, in, cm, mm, em, ex, pt, o pc).","invalidHtmlLength":"El valor especificado para el campo \"%1\" debe ser un número positivo, incluyendo optionalmente una unidad de medida HTML válida (px o %).","invalidInlineStyle":"El valor especificado para el estilo debe consistir en uno o más pares con el formato \"nombre: valor\", separados por punto y coma.","cssLengthTooltip":"Introduca un número para el valor en pixels o un número con una unidad de medida CSS válida (px, %, in, cm, mm, em, ex, pt, o pc).","unavailable":"%1<span class=\"cke_accessibility\">, no disponible</span>","keyboard":{"8":"Retroceso","13":"Ingresar","16":"Mayús.","17":"Ctrl","18":"Alt","32":"Espacio","35":"Fin","36":"Inicio","46":"Suprimir","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Comando"},"keyboardShortcut":"Atajos de teclado","optionDefault":"Default"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Todos los derechos reservados.","dlgTitle":"Acerca de CKEditor 4","moreInfo":"Para información de licencia, por favor visite nuestro sitio web:"},"basicstyles":{"bold":"Negrita","italic":"Cursiva","strike":"Tachado","subscript":"Subíndice","superscript":"Superíndice","underline":"Subrayado"},"bidi":{"ltr":"Dirección del texto de izquierda a derecha","rtl":"Dirección del texto de derecha a izquierda"},"blockquote":{"toolbar":"Cita"},"notification":{"closed":"Notificación cerrada."},"toolbar":{"toolbarCollapse":"Contraer barra de herramientas","toolbarExpand":"Expandir barra de herramientas","toolbarGroups":{"document":"Documento","clipboard":"Portapapeles/Deshacer","editing":"Edición","forms":"Formularios","basicstyles":"Estilos básicos","paragraph":"Párrafo","links":"Enlaces","insert":"Insertar","styles":"Estilos","colors":"Colores","tools":"Herramientas"},"toolbars":"Barras de herramientas del editor"},"clipboard":{"copy":"Copiar","copyError":"La configuración de seguridad de este navegador no permite la ejecución automática de operaciones de copiado.\r\nPor favor use el teclado (Ctrl/Cmd+C).","cut":"Cortar","cutError":"La configuración de seguridad de este navegador no permite la ejecución automática de operaciones de cortado.\r\nPor favor use el teclado (Ctrl/Cmd+X).","paste":"Pegar","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","pasteArea":"Zona de pegado","pasteMsg":"Paste your content inside the area below and press OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automático","bgColorTitle":"Color de Fondo","colors":{"000":"Negro","800000":"Marrón oscuro","8B4513":"Marrón tierra","2F4F4F":"Pizarra Oscuro","008080":"Azul verdoso","000080":"Azul marino","4B0082":"Añil","696969":"Gris oscuro","B22222":"Ladrillo","A52A2A":"Marrón","DAA520":"Oro oscuro","006400":"Verde oscuro","40E0D0":"Turquesa","0000CD":"Azul medio-oscuro","800080":"Púrpura","808080":"Gris","F00":"Rojo","FF8C00":"Naranja oscuro","FFD700":"Oro","008000":"Verde","0FF":"Cian","00F":"Azul","EE82EE":"Violeta","A9A9A9":"Gris medio","FFA07A":"Salmón claro","FFA500":"Naranja","FFFF00":"Amarillo","00FF00":"Lima","AFEEEE":"Turquesa claro","ADD8E6":"Azul claro","DDA0DD":"Violeta claro","D3D3D3":"Gris claro","FFF0F5":"Lavanda rojizo","FAEBD7":"Blanco antiguo","FFFFE0":"Amarillo claro","F0FFF0":"Miel","F0FFFF":"Azul celeste","F0F8FF":"Azul pálido","E6E6FA":"Lavanda","FFF":"Blanco","1ABC9C":"Strong Cyan","2ECC71":"Emerald","3498DB":"Bright Blue","9B59B6":"Amethyst","4E5F70":"Grayish Blue","F1C40F":"Vivid Yellow","16A085":"Dark Cyan","27AE60":"Dark Emerald","2980B9":"Strong Blue","8E44AD":"Dark Violet","2C3E50":"Desaturated Blue","F39C12":"Orange","E67E22":"Carrot","E74C3C":"Pale Red","ECF0F1":"Bright Silver","95A5A6":"Light Grayish Cyan","DDD":"Light Gray","D35400":"Pumpkin","C0392B":"Strong Red","BDC3C7":"Silver","7F8C8D":"Grayish Cyan","999":"Dark Gray"},"more":"Más Colores...","panelTitle":"Colores","textColorTitle":"Color de Texto"},"colordialog":{"clear":"Borrar","highlight":"Muestra","options":"Opciones de colores","selected":"Elegido","title":"Elegir color"},"templates":{"button":"Plantillas","emptyListMsg":"(No hay plantillas definidas)","insertOption":"Reemplazar el contenido actual","options":"Opciones de plantillas","selectPromptMsg":"Por favor selecciona la plantilla a abrir en el editor<br>(el contenido actual se perderá):","title":"Contenido de Plantillas"},"contextmenu":{"options":"Opciones del menú contextual"},"copyformatting":{"label":"Copy Formatting","notification":{"copied":"Formatting copied","applied":"Formatting applied","canceled":"Formatting canceled","failed":"Formatting failed. You cannot apply styles without copying them first."}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Título","cssClassInputLabel":"Clase de hoja de estilos","edit":"Editar Div","inlineStyleInputLabel":"Estilo","langDirLTRLabel":"Izquierda a Derecha (LTR)","langDirLabel":"Orientación","langDirRTLLabel":"Derecha a Izquierda (RTL)","languageCodeInputLabel":" Codigo de idioma","remove":"Quitar Div","styleSelectLabel":"Estilo","title":"Crear contenedor DIV","toolbar":"Crear contenedor DIV"},"elementspath":{"eleLabel":"Ruta de los elementos","eleTitle":"%1 elemento"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Ha ocurrido un error durante la lectura del archivo.","networkError":"Error de red ocurrido durante carga de archivo.","httpError404":"Un error HTTP ha ocurrido durante la carga del archivo (404: Archivo no encontrado).","httpError403":"Un error HTTP ha ocurrido durante la carga del archivo (403: Prohibido).","httpError":"Error HTTP ocurrido durante la carga del archivo (Estado del error: %1).","noUrlError":"URL cargada no está definida.","responseError":"Respueta del servidor incorrecta."},"find":{"find":"Buscar","findOptions":"Opciones de búsqueda","findWhat":"Texto a buscar:","matchCase":"Coincidir may/min","matchCyclic":"Buscar en todo el contenido","matchWord":"Coincidir toda la palabra","notFoundMsg":"El texto especificado no ha sido encontrado.","replace":"Reemplazar","replaceAll":"Reemplazar Todo","replaceSuccessMsg":"La expresión buscada ha sido reemplazada %1 veces.","replaceWith":"Reemplazar con:","title":"Buscar y Reemplazar"},"font":{"fontSize":{"label":"Tamaño","voiceLabel":"Tamaño de fuente","panelTitle":"Tamaño"},"label":"Fuente","panelTitle":"Fuente","voiceLabel":"Fuente"},"fakeobjects":{"anchor":"Ancla","hiddenfield":"Campo oculto","iframe":"IFrame","unknown":"Objeto desconocido"},"forms":{"button":{"title":"Propiedades de Botón","text":"Texto (Valor)","type":"Tipo","typeBtn":"Boton","typeSbm":"Enviar","typeRst":"Reestablecer"},"checkboxAndRadio":{"checkboxTitle":"Propiedades de Casilla","radioTitle":"Propiedades de Botón de Radio","value":"Valor","selected":"Seleccionado","required":"Requerido"},"form":{"title":"Propiedades de Formulario","menu":"Propiedades de Formulario","action":"Acción","method":"Método","encoding":"Codificación"},"hidden":{"title":"Propiedades de Campo Oculto","name":"Nombre","value":"Valor"},"select":{"title":"Propiedades de Campo de Selección","selectInfo":"Información","opAvail":"Opciones disponibles","value":"Valor","size":"Tamaño","lines":"Lineas","chkMulti":"Permitir múltiple selección","required":"Requerido","opText":"Texto","opValue":"Valor","btnAdd":"Agregar","btnModify":"Modificar","btnUp":"Subir","btnDown":"Bajar","btnSetValue":"Establecer como predeterminado","btnDelete":"Eliminar"},"textarea":{"title":"Propiedades de Area de Texto","cols":"Columnas","rows":"Filas"},"textfield":{"title":"Propiedades de Campo de Texto","name":"Nombre","value":"Valor","charWidth":"Caracteres de ancho","maxChars":"Máximo caracteres","required":"Requerido","type":"Tipo","typeText":"Texto","typePass":"Contraseña","typeEmail":"Correo electrónico","typeSearch":"Buscar","typeTel":"Número de teléfono","typeUrl":"URL"}},"format":{"label":"Formato","panelTitle":"Formato","tag_address":"Dirección","tag_div":"Normal (DIV)","tag_h1":"Encabezado 1","tag_h2":"Encabezado 2","tag_h3":"Encabezado 3","tag_h4":"Encabezado 4","tag_h5":"Encabezado 5","tag_h6":"Encabezado 6","tag_p":"Normal","tag_pre":"Con formato"},"horizontalrule":{"toolbar":"Insertar Línea Horizontal"},"iframe":{"border":"Mostrar borde del marco","noUrl":"Por favor, escriba la dirección del iframe","scrolling":"Activar barras de desplazamiento","title":"Propiedades de iframe","toolbar":"IFrame","tabindex":"Remove from tabindex"},"image":{"alt":"Texto Alternativo","border":"Borde","btnUpload":"Enviar al Servidor","button2Img":"¿Desea convertir el botón de imagen en una simple imagen?","hSpace":"Esp.Horiz","img2Button":"¿Desea convertir la imagen en un botón de imagen?","infoTab":"Información de Imagen","linkTab":"Vínculo","lockRatio":"Proporcional","menu":"Propiedades de Imagen","resetSize":"Tamaño Original","title":"Propiedades de Imagen","titleButton":"Propiedades de Botón de Imagen","upload":"Cargar","urlMissing":"Debe indicar la URL de la imagen.","vSpace":"Esp.Vert","validateBorder":"El borde debe ser un número.","validateHSpace":"El espaciado horizontal debe ser un número.","validateVSpace":"El espaciado vertical debe ser un número."},"indent":{"indent":"Aumentar Sangría","outdent":"Disminuir Sangría"},"smiley":{"options":"Opciones de emoticonos","title":"Insertar un Emoticon","toolbar":"Emoticonos"},"language":{"button":"Fijar lenguaje","remove":"Quitar lenguaje"},"link":{"acccessKey":"Tecla de Acceso","advanced":"Avanzado","advisoryContentType":"Tipo de Contenido","advisoryTitle":"Título","anchor":{"toolbar":"Referencia","menu":"Propiedades de Referencia","title":"Propiedades de Referencia","name":"Nombre de la Referencia","errorName":"Por favor, complete el nombre de la Referencia","errorWhitespace":"Anchor name cannot contain space characters","remove":"Quitar Referencia"},"anchorId":"Por ID de elemento","anchorName":"Por Nombre de Referencia","charset":"Fuente de caracteres vinculado","cssClasses":"Clases de hojas de estilo","download":"Forzar la descarga","displayText":"Mostrar texto","emailAddress":"Dirección de E-Mail","emailBody":"Cuerpo del Mensaje","emailSubject":"Título del Mensaje","id":"Id","info":"Información de Vínculo","langCode":"Código idioma","langDir":"Orientación","langDirLTR":"Izquierda a Derecha (LTR)","langDirRTL":"Derecha a Izquierda (RTL)","menu":"Editar Vínculo","name":"Nombre","noAnchors":"(No hay referencias disponibles en el documento)","noEmail":"Por favor escriba la dirección de e-mail","noUrl":"Por favor escriba el vínculo URL","noTel":"Por favor ingrese el numero de telefono","other":"<otro>","phoneNumber":"Phone number","popupDependent":"Dependiente (Netscape)","popupFeatures":"Características de Ventana Emergente","popupFullScreen":"Pantalla Completa (IE)","popupLeft":"Posición Izquierda","popupLocationBar":"Barra de ubicación","popupMenuBar":"Barra de Menú","popupResizable":"Redimensionable","popupScrollBars":"Barras de desplazamiento","popupStatusBar":"Barra de Estado","popupToolbar":"Barra de Herramientas","popupTop":"Posición Derecha","rel":"Relación","selectAnchor":"Seleccionar una referencia","styles":"Estilo","tabIndex":"Indice de tabulación","target":"Destino","targetFrame":"<marco>","targetFrameName":"Nombre del Marco Destino","targetPopup":"<ventana emergente>","targetPopupName":"Nombre de Ventana Emergente","title":"Vínculo","toAnchor":"Referencia en esta página","toEmail":"E-Mail","toUrl":"URL","toPhone":"Teléfono","toolbar":"Insertar/Editar Vínculo","type":"Tipo de vínculo","unlink":"Eliminar Vínculo","upload":"Cargar"},"list":{"bulletedlist":"Viñetas","numberedlist":"Numeración"},"liststyle":{"bulletedTitle":"Propiedades de viñetas","circle":"Círculo","decimal":"Decimal (1, 2, 3, etc.)","disc":"Disco","lowerAlpha":"Alfabeto en minúsculas (a, b, c, d, e, etc.)","lowerRoman":"Números romanos en minúsculas (i, ii, iii, iv, v, etc.)","none":"Ninguno","notset":"<sin establecer>","numberedTitle":"Propiedades de lista numerada","square":"Cuadrado","start":"Inicio","type":"Tipo","upperAlpha":"Alfabeto en mayúsculas  (A, B, C, D, E, etc.)","upperRoman":"Números romanos en mayúsculas (I, II, III, IV, V, etc.)","validateStartNumber":"El Inicio debe ser un número entero."},"magicline":{"title":"Insertar párrafo aquí"},"maximize":{"maximize":"Maximizar","minimize":"Minimizar"},"newpage":{"toolbar":"Nueva Página"},"pagebreak":{"alt":"Salto de página","toolbar":"Insertar Salto de Página"},"pastetext":{"button":"Pegar como Texto Plano","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","title":"Pegar como Texto Plano"},"pastefromword":{"confirmCleanup":"El texto que desea parece provenir de Word.\r\n¿Desea depurarlo antes de pegarlo?","error":"No ha sido posible limpiar los datos debido a un error interno","title":"Pegar desde Word","toolbar":"Pegar desde Word"},"preview":{"preview":"Vista Previa"},"print":{"toolbar":"Imprimir"},"removeformat":{"toolbar":"Eliminar Formato"},"save":{"toolbar":"Guardar"},"selectall":{"toolbar":"Seleccionar Todo"},"showblocks":{"toolbar":"Mostrar bloques"},"sourcearea":{"toolbar":"Fuente HTML"},"specialchar":{"options":"Opciones de caracteres especiales","title":"Seleccione un caracter especial","toolbar":"Insertar Caracter Especial"},"scayt":{"btn_about":"Acerca de Corrector","btn_dictionaries":"Diccionarios","btn_disable":"Desactivar Corrector","btn_enable":"Activar Corrector","btn_langs":"Idiomas","btn_options":"Opciones","text_title":"Comprobar Ortografía Mientras Escribe"},"stylescombo":{"label":"Estilo","panelTitle":"Estilos para formatear","panelTitle1":"Estilos de párrafo","panelTitle2":"Estilos de carácter","panelTitle3":"Estilos de objeto"},"table":{"border":"Tamaño de Borde","caption":"Título","cell":{"menu":"Celda","insertBefore":"Insertar celda a la izquierda","insertAfter":"Insertar celda a la derecha","deleteCell":"Eliminar Celdas","merge":"Combinar Celdas","mergeRight":"Combinar a la derecha","mergeDown":"Combinar hacia abajo","splitHorizontal":"Dividir la celda horizontalmente","splitVertical":"Dividir la celda verticalmente","title":"Propiedades de celda","cellType":"Tipo de Celda","rowSpan":"Expandir filas","colSpan":"Expandir columnas","wordWrap":"Ajustar al contenido","hAlign":"Alineación Horizontal","vAlign":"Alineación Vertical","alignBaseline":"Linea de base","bgColor":"Color de fondo","borderColor":"Color de borde","data":"Datos","header":"Encabezado","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Sí","no":"No","invalidWidth":"La anchura de celda debe ser un número.","invalidHeight":"La altura de celda debe ser un número.","invalidRowSpan":"La expansión de filas debe ser un número entero.","invalidColSpan":"La expansión de columnas debe ser un número entero.","chooseColor":"Elegir"},"cellPad":"Esp. interior","cellSpace":"Esp. e/celdas","column":{"menu":"Columna","insertBefore":"Insertar columna a la izquierda","insertAfter":"Insertar columna a la derecha","deleteColumn":"Eliminar Columnas"},"columns":"Columnas","deleteTable":"Eliminar Tabla","headers":"Encabezados","headersBoth":"Ambas","headersColumn":"Primera columna","headersNone":"Ninguno","headersRow":"Primera fila","heightUnit":"height unit","invalidBorder":"El tamaño del borde debe ser un número.","invalidCellPadding":"El espaciado interior debe ser un número.","invalidCellSpacing":"El espaciado entre celdas debe ser un número.","invalidCols":"El número de columnas debe ser un número mayor que 0.","invalidHeight":"La altura de tabla debe ser un número.","invalidRows":"El número de filas debe ser un número mayor que 0.","invalidWidth":"La anchura de tabla debe ser un número.","menu":"Propiedades de Tabla","row":{"menu":"Fila","insertBefore":"Insertar fila en la parte superior","insertAfter":"Insertar fila en la parte inferior","deleteRow":"Eliminar Filas"},"rows":"Filas","summary":"Síntesis","title":"Propiedades de Tabla","toolbar":"Tabla","widthPc":"porcentaje","widthPx":"pixeles","widthUnit":"unidad de la anchura"},"undo":{"redo":"Rehacer","undo":"Deshacer"},"widget":{"move":"Dar clic y arrastrar para mover","label":"reproductor %1"},"uploadwidget":{"abort":"Carga abortada por el usuario.","doneOne":"Archivo cargado exitósamente.","doneMany":"%1 archivos exitósamente cargados.","uploadOne":"Cargando archivo ({percentage}%)...","uploadMany":"Cargando archivos, {current} de {max} hecho ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Fuente HTML","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Search emoji…","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"Emoji List","groups":{"people":"People","nature":"Nature and animals","food":"Food and drinks","travel":"Travel and places","activities":"Activities","objects":"Objects","symbols":"Symbols","flags":"Flags"}},"html5video":{"button":"Insertar video HTML5","title":"Video HTML5","infoLabel":"Información del video","allowed":"Extensiones de archivo permitidas: MP4, WebM, Ogv","urlMissing":"La URL del video no puede estar vacía.","videoProperties":"Propiedades del video","upload":"Cargar","btnUpload":"Enviar al servidor","advanced":"Avanzado","autoplay":"¿Reproducir automáticamente?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Sí","no":"No","responsive":"¿Responsive?","controls":"Mostrar controles","loop":"Loop?","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Fuente HTML","title":"Fuente HTML"}};