## Getting Started with A11yFirst

### What is A11yFirst?

Before you begin using the A11yFirst editor, it is important to know what
makes it different from other editors. The name *A11yFirst* hints at some
of these differences.

*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and
accessibility in the context of document authoring is about making the
information that documents contain perceivable and understandable by everyone,
including people with disabilities.</p>

### Commitment to accessibility

Your organization, by hosting the A11yFirst editor within its content
management system, has made a commitment to accessibility because (1) it
removes barriers that people with visual, auditory, learning and other
disabilities may experience in their use of web information and communication
technologies and (2) it is required by law.

By following accessibility guidelines when creating public-facing documents,
you are fulfilling your role in this commitment.

### Document accessibility

Some of the main components within a document that are important for
accessibility are:

* **Headings** — These provide titles for the sections and subsections of
content within your document, as well as a title for the document itself.

* **Lists** — By using the list feature, the items in a list are grouped
together and information about the grouping can be conveyed to users of
assistive technologies.

* **Links** — The text component of a link should describe its target, i.e.,
the web site, page or section that will be displayed if you activate the link.

* **Images** — When an image with informational content is included within a
document, a short text description (also known as ‘alt text’) allows screen
reader users to obtain a concise description of the image.

* **Tables** — By using the table feature to organize tabular data and provide row
and column headers, users of assistive technologies gain the ability to easily
navigate and understand structural relationships within the data.

### A different way of thinking

The way you think about the process or workflow of creating and editing
documents can make a significant difference in whether the end result, your
finished document, is accessible.

For example, rather than thinking about stylistic considerations such as font
sizes and colors first, if you make the structure of your document a primary
consideration, by breaking it down into sections and subsections and giving
each of these a meaningful title, you will end up with a document that will
be easier for all users to navigate and understand, including people with
disabilities.
