﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['sv']={"application":"Rich Text Editor","editor":"Rich Text-editor","editorPanel":"Panel till Rich Text-editor","common":{"editorHelp":"Tryck ALT 0 för hjälp","browseServer":"Bläddra på server","url":"URL","protocol":"Protokoll","upload":"Ladda upp","uploadSubmit":"Skicka till server","image":"Bild","form":"Formulär","checkbox":"Kryssruta","radio":"Alternativknapp","textField":"Textfält","textarea":"Textruta","hiddenField":"Dolt fält","button":"Knapp","select":"Flervalslista","imageButton":"Bildknapp","notSet":"<ej angivet>","id":"Id","name":"Namn","langDir":"Språkriktning","langDirLtr":"Vänster till Höger (VTH)","langDirRtl":"Höger till Vänster (HTV)","langCode":"Språkkod","longDescr":"URL-beskrivning","cssClass":"Stilmall","advisoryTitle":"Titel","cssStyle":"Stilmall","ok":"OK","cancel":"Avbryt","close":"Stäng","preview":"Förhandsgranska","resize":"Dra för att ändra storlek","generalTab":"Allmänt","advancedTab":"Avancerad","validateNumberFailed":"Värdet är inte ett nummer.","confirmNewPage":"Alla ändringar i innehållet kommer att förloras. Är du säker på att du vill ladda en ny sida?","confirmCancel":"Några av alternativen har ändrats. Är du säker på att du vill stänga dialogrutan?","options":"Alternativ","target":"Mål","targetNew":"Nytt fönster (_blank)","targetTop":"Översta fönstret (_top)","targetSelf":"Samma fönster (_self)","targetParent":"Föregående fönster (_parent)","langDirLTR":"Vänster till höger (LTR)","langDirRTL":"Höger till vänster (RTL)","styles":"Stil","cssClasses":"Stilmallar","width":"Bredd","height":"Höjd","align":"Justering","left":"Vänster","right":"Höger","center":"Centrerad","justify":"Justera till marginaler","alignLeft":"Vänsterjustera","alignRight":"Högerjustera","alignCenter":"Centrera","alignTop":"Överkant","alignMiddle":"Mitten","alignBottom":"Nederkant","alignNone":"Ingen","invalidValue":"Felaktigt värde.","invalidHeight":"Höjd måste vara ett nummer.","invalidWidth":"Bredd måste vara ett nummer.","invalidLength":"Värdet för fältet \"%1\" måste vara ett positivt nummer med eller utan en giltig mätenhet (%2).","invalidCssLength":"Värdet för fältet \"%1\" måste vara ett positivt nummer med eller utan CSS-mätenheter (px, %, in, cm, mm, em, ex, pt, eller pc).","invalidHtmlLength":"Värdet för fältet \"%1\" måste vara ett positivt nummer med eller utan godkända HTML-mätenheter (px eller %).","invalidInlineStyle":"Det angivna värdet för style måste innehålla en eller flera tupler separerade med semikolon i följande format: \"name : value\"","cssLengthTooltip":"Ange ett nummer i pixlar eller ett nummer men godkänd CSS-mätenhet (px, %, in, cm, mm, em, ex, pt, eller pc).","unavailable":"%1<span class=\"cke_accessibility\">, Ej tillgänglig</span>","keyboard":{"8":"Backsteg","13":"Retur","16":"Skift","17":"Ctrl","18":"Alt","32":"Mellanslag","35":"Slut","36":"Hem","46":"Radera","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Kommando"},"keyboardShortcut":"Kortkommando","optionDefault":"Standard"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Alla rättigheter reserverade.","dlgTitle":"Om CKEditor 4","moreInfo":"För information om licensiering besök vår hemsida:"},"basicstyles":{"bold":"Fet","italic":"Kursiv","strike":"Genomstruken","subscript":"Nedsänkta tecken","superscript":"Upphöjda tecken","underline":"Understruken"},"bidi":{"ltr":"Text riktning från vänster till höger","rtl":"Text riktning från höger till vänster"},"blockquote":{"toolbar":"Blockcitat"},"notification":{"closed":"Notifiering stängd."},"toolbar":{"toolbarCollapse":"Dölj verktygsfält","toolbarExpand":"Visa verktygsfält","toolbarGroups":{"document":"Dokument","clipboard":"Urklipp/ångra","editing":"Redigering","forms":"Formulär","basicstyles":"Basstilar","paragraph":"Paragraf","links":"Länkar","insert":"Infoga","styles":"Stilar","colors":"Färger","tools":"Verktyg"},"toolbars":"Editorns verktygsfält"},"clipboard":{"copy":"Kopiera","copyError":"Säkerhetsinställningar i din webbläsare tillåter inte åtgärden kopiera. Använd (Ctrl/Cmd+C) istället.","cut":"Klipp ut","cutError":"Säkerhetsinställningar i din webbläsare tillåter inte åtgärden klipp ut. Använd (Ctrl/Cmd+X) istället.","paste":"Klistra in","pasteNotification":"Tryck på %1 för att klistra in. Din webbläsare stödjer inte inklistring via verktygsfältet eller snabbmenyn.","pasteArea":"Inklistringsområde","pasteMsg":"Klistra in ditt innehåll i området nedan och tryck på OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automatisk","bgColorTitle":"Bakgrundsfärg","colors":{"000":"Svart","800000":"Rödbrun","8B4513":"Mörkbrun","2F4F4F":"Skiffergrå","008080":"Kricka","000080":"Marinblå","4B0082":"Indigo","696969":"Mörkgrå","B22222":"Tegelsten","A52A2A":"Brun","DAA520":"Mörk guld","006400":"Mörkgrön","40E0D0":"Turkos","0000CD":"Medium blå","800080":"Lila","808080":"Grå","F00":"Röd","FF8C00":"Mörkorange","FFD700":"Guld","008000":"Grön","0FF":"Turkos","00F":"Blå","EE82EE":"Violett","A9A9A9":"Matt grå","FFA07A":"Laxrosa","FFA500":"Orange","FFFF00":"Gul","00FF00":"Lime","AFEEEE":"Ljusturkos","ADD8E6":"Ljusblå","DDA0DD":"Plommon","D3D3D3":"Ljusgrå","FFF0F5":"Ljus lavendel","FAEBD7":"Antikvit","FFFFE0":"Ljusgul","F0FFF0":"Honungsdagg","F0FFFF":"Azurblå","F0F8FF":"Aliceblå","E6E6FA":"Lavendel","FFF":"Vit","1ABC9C":"Stark turkos","2ECC71":"Smaragd","3498DB":"Klarblå","9B59B6":"Ametist","4E5F70":"Gråblå","F1C40F":"Klargul","16A085":"Mörk turkos","27AE60":"Mörk smaragd","2980B9":"Stark blå","8E44AD":"Mörk violett","2C3E50":"Blek blå","F39C12":"Orange","E67E22":"Morot","E74C3C":"Blekröd","ECF0F1":"Stark silver","95A5A6":"Ljus gråaktig turkos","DDD":"Ljusgrå","D35400":"Pumpa","C0392B":"Stark röd","BDC3C7":"Silver","7F8C8D":"Gråaktig turkos","999":"Mörkgrå"},"more":"Fler färger...","panelTitle":"Färger","textColorTitle":"Textfärg"},"colordialog":{"clear":"Rensa","highlight":"Markera","options":"Färgalternativ","selected":"Vald färg","title":"Välj färg"},"templates":{"button":"Sidmallar","emptyListMsg":"(Ingen mall är vald)","insertOption":"Ersätt aktuellt innehåll","options":"Inställningar för mall","selectPromptMsg":"Var god välj en mall att använda med editorn<br>(allt nuvarande innehåll raderas):","title":"Sidmallar"},"contextmenu":{"options":"Context Menu Options"},"copyformatting":{"label":"Kopiera formatering","notification":{"copied":"Formatering kopierad","applied":"Formatering applicerad","canceled":"Formatering avbruten","failed":"Formatering misslyckades. Du kan inte applicera stilar utan att kopiera dem först."}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Rådgivande titel","cssClassInputLabel":"Stilmallar","edit":"Redigera Div","inlineStyleInputLabel":"Inline Style","langDirLTRLabel":"Vänster till höger (LTR)","langDirLabel":"Språkriktning","langDirRTLLabel":"Höger till vänster (RTL)","languageCodeInputLabel":" Språkkod","remove":"Ta bort Div","styleSelectLabel":"Stil","title":"Skapa Div container","toolbar":"Skapa Div container"},"elementspath":{"eleLabel":"Elementets sökväg","eleTitle":"%1 element"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Fel uppstod vid filläsning","networkError":"Nätverksfel uppstod vid filuppladdning.","httpError404":"HTTP-fel uppstod vid filuppladdning (404: Fil hittades inte).","httpError403":"HTTP-fel uppstod vid filuppladdning (403: Förbjuden).","httpError":"HTTP-fel uppstod vid filuppladdning (felstatus: %1).","noUrlError":"URL för uppladdning inte definierad.","responseError":"Felaktigt serversvar."},"find":{"find":"Sök","findOptions":"Sökalternativ","findWhat":"Sök efter:","matchCase":"Skiftläge","matchCyclic":"Matcha cykliska","matchWord":"Inkludera hela ord","notFoundMsg":"Angiven text kunde ej hittas.","replace":"Ersätt","replaceAll":"Ersätt alla","replaceSuccessMsg":"%1 förekomst(er) ersatta.","replaceWith":"Ersätt med:","title":"Sök och ersätt"},"font":{"fontSize":{"label":"Storlek","voiceLabel":"Teckenstorlek","panelTitle":"Teckenstorlek"},"label":"Typsnitt","panelTitle":"Typsnitt","voiceLabel":"Typsnitt"},"fakeobjects":{"anchor":"Ankare","hiddenfield":"Gömt fält","iframe":"iFrame","unknown":"Okänt objekt"},"forms":{"button":{"title":"Egenskaper för knapp","text":"Text (värde)","type":"Typ","typeBtn":"Knapp","typeSbm":"Skicka","typeRst":"Återställ"},"checkboxAndRadio":{"checkboxTitle":"Egenskaper för kryssruta","radioTitle":"Egenskaper för alternativknapp","value":"Värde","selected":"Vald","required":"Krävs"},"form":{"title":"Egenskaper för formulär","menu":"Egenskaper för formulär","action":"Funktion","method":"Metod","encoding":"Kodning"},"hidden":{"title":"Egenskaper för dolt fält","name":"Namn","value":"Värde"},"select":{"title":"Egenskaper för flervalslista","selectInfo":"Information","opAvail":"Befintliga val","value":"Värde","size":"Storlek","lines":"Linjer","chkMulti":"Tillåt flerval","required":"Krävs","opText":"Text","opValue":"Värde","btnAdd":"Lägg till","btnModify":"Redigera","btnUp":"Upp","btnDown":"Ner","btnSetValue":"Markera som valt värde","btnDelete":"Radera"},"textarea":{"title":"Egenskaper för textruta","cols":"Kolumner","rows":"Rader"},"textfield":{"title":"Egenskaper för textfält","name":"Namn","value":"Värde","charWidth":"Teckenbredd","maxChars":"Max antal tecken","required":"Krävs","type":"Typ","typeText":"Text","typePass":"Lösenord","typeEmail":"E-post","typeSearch":"Sök","typeTel":"Telefonnummer","typeUrl":"URL"}},"format":{"label":"Teckenformat","panelTitle":"Teckenformat","tag_address":"Adress","tag_div":"Normal (DIV)","tag_h1":"Rubrik 1","tag_h2":"Rubrik 2","tag_h3":"Rubrik 3","tag_h4":"Rubrik 4","tag_h5":"Rubrik 5","tag_h6":"Rubrik 6","tag_p":"Normal","tag_pre":"Formaterad"},"horizontalrule":{"toolbar":"Infoga horisontal linje"},"iframe":{"border":"Visa ramkant","noUrl":"Skriv in URL för iFrame","scrolling":"Aktivera rullningslister","title":"iFrame-egenskaper","toolbar":"iFrame","tabindex":"Ta bort från tabindex"},"image":{"alt":"Alternativ text","border":"Kant","btnUpload":"Skicka till server","button2Img":"Vill du omvandla den valda bildknappen på en enkel bild?","hSpace":"Horis. marginal","img2Button":"Vill du omvandla den valda bildknappen på en enkel bild?","infoTab":"Bildinformation","linkTab":"Länk","lockRatio":"Lås höjd/bredd förhållanden","menu":"Bildegenskaper","resetSize":"Återställ storlek","title":"Bildegenskaper","titleButton":"Egenskaper för bildknapp","upload":"Ladda upp","urlMissing":"Bildkällans URL saknas.","vSpace":"Vert. marginal","validateBorder":"Kantlinje måste vara ett heltal.","validateHSpace":"HSpace måste vara ett heltal.","validateVSpace":"VSpace måste vara ett heltal."},"indent":{"indent":"Öka indrag","outdent":"Minska indrag"},"smiley":{"options":"Smileyinställningar","title":"Infoga smiley","toolbar":"Smiley"},"language":{"button":"Sätt språk","remove":"Ta bort språk"},"link":{"acccessKey":"Behörighetsnyckel","advanced":"Avancerad","advisoryContentType":"Innehållstyp","advisoryTitle":"Titel","anchor":{"toolbar":"Infoga/Redigera ankarlänk","menu":"Egenskaper för ankarlänk","title":"Egenskaper för ankarlänk","name":"Ankarnamn","errorName":"Var god ange ett ankarnamn","errorWhitespace":"Anchor name cannot contain space characters","remove":"Radera ankare"},"anchorId":"Efter element-id","anchorName":"Efter ankarnamn","charset":"Teckenuppställning","cssClasses":"Stilmall","download":"Tvinga nerladdning","displayText":"Visningstext","emailAddress":"E-postadress","emailBody":"Innehåll","emailSubject":"Ämne","id":"Id","info":"Länkinformation","langCode":"Språkkod","langDir":"Språkriktning","langDirLTR":"Vänster till höger (VTH)","langDirRTL":"Höger till vänster (HTV)","menu":"Redigera länk","name":"Namn","noAnchors":"(Inga ankare kunde hittas)","noEmail":"Var god ange e-postadress","noUrl":"Var god ange länkens URL","noTel":"Var god ange telefonnummer","other":"<annan>","phoneNumber":"Telefonnummer","popupDependent":"Beroende (endast Netscape)","popupFeatures":"Popup-fönstrets egenskaper","popupFullScreen":"Helskärm (endast IE)","popupLeft":"Position från vänster","popupLocationBar":"Adressfält","popupMenuBar":"Menyfält","popupResizable":"Skalbart","popupScrollBars":"Scrolllista","popupStatusBar":"Statusfält","popupToolbar":"Verktygsfält","popupTop":"Position från sidans topp","rel":"Förhållande","selectAnchor":"Välj ett ankare","styles":"Stilmall","tabIndex":"Tabindex","target":"Mål","targetFrame":"<ram>","targetFrameName":"Målets ramnamn","targetPopup":"<popup-fönster>","targetPopupName":"Popup-fönstrets namn","title":"Länk","toAnchor":"Länk till ankare i texten","toEmail":"E-post","toUrl":"URL","toPhone":"Telefon","toolbar":"Infoga/Redigera länk","type":"Länktyp","unlink":"Radera länk","upload":"Ladda upp"},"list":{"bulletedlist":"Infoga/ta bort punktlista","numberedlist":"Infoga/ta bort numrerad lista"},"liststyle":{"bulletedTitle":"Egenskaper för punktlista","circle":"Cirkel","decimal":"Decimal (1, 2, 3, etc.)","disc":"Disk","lowerAlpha":"Alpha gemener (a, b, c, d, e, etc.)","lowerRoman":"Romerska gemener (i, ii, iii, iv, v, etc.)","none":"Ingen","notset":"<ej angiven>","numberedTitle":"Egenskaper för punktlista","square":"Fyrkant","start":"Start","type":"Typ","upperAlpha":"Alpha versaler (A, B, C, D, E, etc.)","upperRoman":"Romerska versaler (I, II, III, IV, V, etc.)","validateStartNumber":"Listans startnummer måste vara ett heltal."},"magicline":{"title":"Infoga paragraf här"},"maximize":{"maximize":"Maximera","minimize":"Minimera"},"newpage":{"toolbar":"Ny sida"},"pagebreak":{"alt":"Sidbrytning","toolbar":"Infoga sidbrytning för utskrift"},"pastetext":{"button":"Klistra in som vanlig text","pasteNotification":"Tryck på %1 för att klistra in. Din webbläsare stödjer inte inklistring via verktygsfältet eller snabbmenyn.","title":"Klistra in som vanlig text"},"pastefromword":{"confirmCleanup":"Texten du vill klistra in verkar vara kopierad från Word. Vill du rensa den innan du klistrar in den?","error":"Det var inte möjligt att städa upp den inklistrade data på grund av ett internt fel","title":"Klistra in från Word","toolbar":"Klistra in från Word"},"preview":{"preview":"Förhandsgranska"},"print":{"toolbar":"Skriv ut"},"removeformat":{"toolbar":"Radera formatering"},"save":{"toolbar":"Spara"},"selectall":{"toolbar":"Markera allt"},"showblocks":{"toolbar":"Visa block"},"sourcearea":{"toolbar":"Källa"},"specialchar":{"options":"Alternativ för utökade tecken","title":"Välj utökat tecken","toolbar":"Klistra in utökat tecken"},"scayt":{"btn_about":"Om SCAYT","btn_dictionaries":"Ordlistor","btn_disable":"Inaktivera SCAYT","btn_enable":"Aktivera SCAYT","btn_langs":"Språk","btn_options":"Inställningar","text_title":"Stavningskontroll medan du skriver"},"stylescombo":{"label":"Stilar","panelTitle":"Formateringsstilar","panelTitle1":"Blockstilar","panelTitle2":"Inbäddade stilar","panelTitle3":"Objektstilar"},"table":{"border":"Kantstorlek","caption":"Rubrik","cell":{"menu":"Cell","insertBefore":"Lägg till cell före","insertAfter":"Lägg till cell efter","deleteCell":"Radera celler","merge":"Sammanfoga celler","mergeRight":"Sammanfoga höger","mergeDown":"Sammanfoga ner","splitHorizontal":"Dela cell horisontellt","splitVertical":"Dela cell vertikalt","title":"Egenskaper för cell","cellType":"Celltyp","rowSpan":"Rad spann","colSpan":"Kolumnen spann","wordWrap":"Radbrytning","hAlign":"Horisontell justering","vAlign":"Vertikal justering","alignBaseline":"Baslinje","bgColor":"Bakgrundsfärg","borderColor":"Ramfärg","data":"Data","header":"Rubrik","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Ja","no":"Nej","invalidWidth":"Cellens bredd måste vara ett nummer.","invalidHeight":"Cellens höjd måste vara ett nummer.","invalidRowSpan":"Radutvidgning måste vara ett heltal.","invalidColSpan":"Kolumn måste vara ett heltal.","chooseColor":"Välj"},"cellPad":"Cellutfyllnad","cellSpace":"Cellavstånd","column":{"menu":"Kolumn","insertBefore":"Lägg till kolumn före","insertAfter":"Lägg till kolumn efter","deleteColumn":"Radera kolumn"},"columns":"Kolumner","deleteTable":"Radera tabell","headers":"Rubriker","headersBoth":"Båda","headersColumn":"Första kolumnen","headersNone":"Ingen","headersRow":"Första raden","heightUnit":"Enhetshöjd","invalidBorder":"Ram måste vara ett nummer.","invalidCellPadding":"Luft i cell måste vara ett nummer.","invalidCellSpacing":"Luft i cell måste vara ett nummer.","invalidCols":"Antal kolumner måste vara ett nummer större än 0.","invalidHeight":"Tabellens höjd måste vara ett nummer.","invalidRows":"Antal rader måste vara större än 0.","invalidWidth":"Tabell måste vara ett nummer.","menu":"Tabellegenskaper","row":{"menu":"Rad","insertBefore":"Lägg till rad före","insertAfter":"Lägg till rad efter","deleteRow":"Radera rad"},"rows":"Rader","summary":"Sammanfattning","title":"Tabellegenskaper","toolbar":"Tabell","widthPc":"procent","widthPx":"pixlar","widthUnit":"enhet bredd"},"undo":{"redo":"Gör om","undo":"Ångra"},"widget":{"move":"Klicka och drag för att flytta","label":"%1-widget"},"uploadwidget":{"abort":"Uppladdning avbruten av användaren.","doneOne":"Filuppladdning lyckades.","doneMany":"Uppladdning av %1 filer lyckades.","uploadOne":"Laddar upp fil ({percentage}%)...","uploadMany":"Laddar upp filer, {current} av {max} färdiga ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Källa","searchCode":"Search Source","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection","commentSelectedRange":"Comment Selection","uncommentSelectedRange":"Uncomment Selection","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Sök emoji...","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"Emojilista","groups":{"people":"Människor","nature":"Natur och djur","food":"Mat och dryck","travel":"Resor och platser","activities":"Aktiviteter","objects":"Objekt","symbols":"Symboler","flags":"Flaggor"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Källa","title":"Källa"}};