## Heading / Paragraph

### Menu items
* **H1 – Document title** — Typically should be the first heading in the
  document and used only once.
* **H2 – Section title** — Describes a main or top-level section in the
  document.
* **H3 to H6 – Subsection title** — Describes a subsection within a top-level
  section or other subsection of the document.
* **Normal** — The default paragraph format, typically with significant top
  and bottom margins.
* **Preformatted text** — Use this for computer code blocks to maintain spacing
  and indentation.
* **Address line** — Use this to type a series of address lines styled in
  italics and with minimal top and bottom margins. When you press enter at the
  end of a line, the next line is also an address line.

### About headings
* The Heading / Paragraph menu only enables the **allowed** heading levels.

* The cursor position relative to other headings in the document determines
which heading levels are allowed.

### About paragraph formats
* Visual styling for paragraph formats is predetermined by your organization,
thus freeing up your time and energy for concentrating on the structure and
meaning of the content within your document.

### Why headings and paragraph formats are important
* The purpose of a heading is to label the content that follows it.

* The proper nesting of heading levels improves the ability of all users to
find and comprehend information on a page.

* Headings used consistently and in meaningful ways improve Search Engine
Optimization (SEO).

* Properly nested headings enable people using assistive technologies to easily
navigate to each section of a document.

* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),
they help users of assistive technologies understand the intended role of the
content.

* Thinking in terms of blocks such as headings and paragraph formats within
your document is a higher-level approach to providing structure and semantics
that are important for all users.

### More information
* Documents are easier to read and understand when headings identify the topics
they contain.

* Headings make it easier to scan and find topics of interest within a document.

* Heading levels identify the structural relationships between sections of
content in a document.

* Higher-level headings (Levels 1 and 2) identify the main topics of a document
and lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the
document.

* A subsection is identified by using the next lower-level heading. For
example, subsections of Level 2 headings use Level 3 headings, subsections of
Level 3 headings use Level 4 headings, and so on to Level 6 headings.

* Break content into subsections when there are two or more ideas or concepts
that correspond to the topics covered in the section. Use headings of the same
level to label each subsection.

* Heading levels should **never** be used for inline visual styling of content
(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline
Style` options.
