﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['it']={"application":"Rich Text Editor","editor":"Editor","editorPanel":"Pannello Rich Text Editor","common":{"editorHelp":"Premi ALT 0 per aiuto","browseServer":"Cerca sul server","url":"URL","protocol":"Protocollo","upload":"Carica","uploadSubmit":"Invia al server","image":"Immagine","form":"Modulo","checkbox":"Checkbox","radio":"Radio Button","textField":"Campo di testo","textarea":"Area di testo","hiddenField":"Campo nascosto","button":"Bottone","select":"Menu di selezione","imageButton":"Bottone immagine","notSet":"<non impostato>","id":"Id","name":"Nome","langDir":"Direzione scrittura","langDirLtr":"Da Sinistra a Destra (LTR)","langDirRtl":"Da Destra a Sinistra (RTL)","langCode":"Codice Lingua","longDescr":"URL descrizione estesa","cssClass":"Nome classe CSS","advisoryTitle":"Titolo","cssStyle":"Stile","ok":"OK","cancel":"Annulla","close":"Chiudi","preview":"Anteprima","resize":"Trascina per ridimensionare","generalTab":"Generale","advancedTab":"Avanzate","validateNumberFailed":"Il valore inserito non è un numero.","confirmNewPage":"Ogni modifica non salvata sarà persa. Sei sicuro di voler caricare una nuova pagina?","confirmCancel":"Alcune delle opzioni sono state cambiate. Sei sicuro di voler chiudere la finestra di dialogo?","options":"Opzioni","target":"Destinazione","targetNew":"Nuova finestra (_blank)","targetTop":"Finestra in primo piano (_top)","targetSelf":"Stessa finestra (_self)","targetParent":"Finestra Padre (_parent)","langDirLTR":"Da sinistra a destra (LTR)","langDirRTL":"Da destra a sinistra (RTL)","styles":"Stile","cssClasses":"Classi di stile","width":"Larghezza","height":"Altezza","align":"Allineamento","left":"Sinistra","right":"Destra","center":"Centrato","justify":"Giustifica","alignLeft":"Allinea a sinistra","alignRight":"Allinea a destra","alignCenter":"Allinea al centro","alignTop":"In Alto","alignMiddle":"Centrato","alignBottom":"In Basso","alignNone":"Nessuno","invalidValue":"Valore non valido.","invalidHeight":"L'altezza dev'essere un numero","invalidWidth":"La Larghezza dev'essere un numero","invalidLength":"Il valore specificato per il campo \"%1\" deve essere un numero positivo con o senza un'unità di misura valida (%2).","invalidCssLength":"Il valore indicato per il campo \"%1\" deve essere un numero positivo con o senza indicazione di una valida unità di misura per le classi CSS (px, %, in, cm, mm, em, ex, pt, o pc).","invalidHtmlLength":"Il valore indicato per il campo \"%1\" deve essere un numero positivo con o senza indicazione di una valida unità di misura per le pagine HTML (px o %).","invalidInlineStyle":"Il valore specificato per lo stile inline deve consistere in una o più tuple con il formato di \"name : value\", separati da semicolonne.","cssLengthTooltip":"Inserisci un numero per il valore in pixel oppure un numero con una valida unità CSS (px, %, in, cm, mm, ex, pt, o pc).","unavailable":"%1<span class=\"cke_accessibility\">, non disponibile</span>","keyboard":{"8":"Backspace","13":"Invio","16":"Maiusc","17":"Ctrl","18":"Alt","32":"Spazio","35":"Fine","36":"Inizio","46":"Canc","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Comando"},"keyboardShortcut":"Scorciatoia da tastiera","optionDefault":"Predefinito"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Tutti i diritti riservati.","dlgTitle":"Informazioni su CKEditor 4","moreInfo":"Per le informazioni sulla licenza si prega di visitare il nostro sito:"},"basicstyles":{"bold":"Grassetto","italic":"Corsivo","strike":"Barrato","subscript":"Pedice","superscript":"Apice","underline":"Sottolineato"},"bidi":{"ltr":"Direzione del testo da sinistra verso destra","rtl":"Direzione del testo da destra verso sinistra"},"blockquote":{"toolbar":"Citazione"},"notification":{"closed":"Notifica chiusa."},"toolbar":{"toolbarCollapse":"Minimizza Toolbar","toolbarExpand":"Espandi Toolbar","toolbarGroups":{"document":"Documento","clipboard":"Copia negli appunti/Annulla","editing":"Modifica","forms":"Form","basicstyles":"Stili di base","paragraph":"Paragrafo","links":"Link","insert":"Inserisci","styles":"Stili","colors":"Colori","tools":"Strumenti"},"toolbars":"Editor toolbar"},"clipboard":{"copy":"Copia","copyError":"Le impostazioni di sicurezza del browser non permettono di copiare automaticamente il testo. Usa la tastiera (Ctrl/Cmd+C).","cut":"Taglia","cutError":"Le impostazioni di sicurezza del browser non permettono di tagliare automaticamente il testo. Usa la tastiera (Ctrl/Cmd+X).","paste":"Incolla","pasteNotification":"Premere %1 per incollare. Il tuo browser non permette di incollare tramite il pulsante della barra degli strumenti o tramite la voce del menu contestuale.","pasteArea":"Area dove incollare","pasteMsg":"Incollare il proprio contenuto all'interno dell'area sottostante e premere OK.","fileFormatNotSupportedNotification":"I file in formato ${formats} non sono supportati.","fileWithoutFormatNotSupportedNotification":"Il formato di file non è supportato."},"colorbutton":{"auto":"Automatico","bgColorTitle":"Colore sfondo","colors":{"000":"Nero","800000":"Marrone Castagna","8B4513":"Marrone Cuoio","2F4F4F":"Grigio Fumo di Londra","008080":"Acquamarina","000080":"Blu Oceano","4B0082":"Indigo","696969":"Grigio Scuro","B22222":"Giallo Fiamma","A52A2A":"Marrone","DAA520":"Giallo Mimosa","006400":"Verde Scuro","40E0D0":"Turchese","0000CD":"Blue Scuro","800080":"Viola","808080":"Grigio","F00":"Rosso","FF8C00":"Arancio Scuro","FFD700":"Oro","008000":"Verde","0FF":"Ciano","00F":"Blu","EE82EE":"Violetto","A9A9A9":"Grigio Scuro","FFA07A":"Salmone","FFA500":"Arancio","FFFF00":"Giallo","00FF00":"Lime","AFEEEE":"Turchese Chiaro","ADD8E6":"Blu Chiaro","DDA0DD":"Rosso Ciliegia","D3D3D3":"Grigio Chiaro","FFF0F5":"Lavanda Chiara","FAEBD7":"Bianco Antico","FFFFE0":"Giallo Chiaro","F0FFF0":"Verde Mela","F0FFFF":"Azzurro","F0F8FF":"Celeste","E6E6FA":"Lavanda","FFF":"Bianco","1ABC9C":"Ciano intenso","2ECC71":"Smeraldo","3498DB":"Blu luminoso","9B59B6":"Ametista","4E5F70":"Blu grigiastro","F1C40F":"Giallo vivido","16A085":"Ciano scuro","27AE60":"Smeraldo scuro","2980B9":"Blu intenso","8E44AD":"Viola scuro","2C3E50":"Blu desaturato","F39C12":"Arancio","E67E22":"Carota","E74C3C":"Rosso pallido","ECF0F1":"Argento luminoso","95A5A6":"Ciano grigiastro chiaro","DDD":"Grigio chiaro","D35400":"Zucca","C0392B":"Rosso intenso","BDC3C7":"Argento","7F8C8D":"Ciano grigiastro","999":"Grigio scuro"},"more":"Altri colori...","panelTitle":"Colori","textColorTitle":"Colore testo"},"colordialog":{"clear":"cancella","highlight":"Evidenzia","options":"Opzioni colore","selected":"Seleziona il colore","title":"Selezionare il colore"},"templates":{"button":"Modelli","emptyListMsg":"(Nessun modello definito)","insertOption":"Cancella il contenuto corrente","options":"Opzioni del Modello","selectPromptMsg":"Seleziona il modello da aprire nell'editor","title":"Contenuto dei modelli"},"contextmenu":{"options":"Opzioni del menù contestuale"},"copyformatting":{"label":"Copia formattazione","notification":{"copied":"Formattazione copiata","applied":"Formattazione applicata","canceled":"Formattazione annullata","failed":"Formattazione fallita. Non è possibile applicare stili senza averli prima copiati."}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Titolo Avviso","cssClassInputLabel":"Classi di stile","edit":"Modifica DIV","inlineStyleInputLabel":"Stile Inline","langDirLTRLabel":"Da sinistra a destra (LTR)","langDirLabel":"Direzione di scrittura","langDirRTLLabel":"Da destra a sinistra (RTL)","languageCodeInputLabel":"Codice lingua","remove":"Rimuovi DIV","styleSelectLabel":"Stile","title":"Crea DIV contenitore","toolbar":"Crea DIV contenitore"},"elementspath":{"eleLabel":"Percorso degli elementi","eleTitle":"%1 elemento"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Si è verificato un errore durante la lettura del file.","networkError":"Si è verificato un errore di rete durante il caricamento del file.","httpError404":"Si è verificato un errore HTTP durante il caricamento del file (404: file non trovato).","httpError403":"Si è verificato un errore HTTP durante il caricamento del file (403: accesso negato).","httpError":"Si è verificato un errore HTTP durante il caricamento del file (stato dell'errore: %1).","noUrlError":"L'URL per il caricamento non è stato definito.","responseError":"La risposta del server non è corretta."},"find":{"find":"Trova","findOptions":"Opzioni di ricerca","findWhat":"Trova:","matchCase":"Maiuscole/minuscole","matchCyclic":"Ricerca ciclica","matchWord":"Solo parole intere","notFoundMsg":"L'elemento cercato non è stato trovato.","replace":"Sostituisci","replaceAll":"Sostituisci tutto","replaceSuccessMsg":"%1 occorrenza(e) sostituite.","replaceWith":"Sostituisci con:","title":"Cerca e Sostituisci"},"font":{"fontSize":{"label":"Dimensione","voiceLabel":"Dimensione Carattere","panelTitle":"Dimensione"},"label":"Carattere","panelTitle":"Carattere","voiceLabel":"Carattere"},"fakeobjects":{"anchor":"Ancora","hiddenfield":"Campo Nascosto","iframe":"IFrame","unknown":"Oggetto sconosciuto"},"forms":{"button":{"title":"Proprietà bottone","text":"Testo (Valore)","type":"Tipo","typeBtn":"Bottone","typeSbm":"Invio","typeRst":"Annulla"},"checkboxAndRadio":{"checkboxTitle":"Proprietà checkbox","radioTitle":"Proprietà radio button","value":"Valore","selected":"Selezionato","required":"Richiesto"},"form":{"title":"Proprietà modulo","menu":"Proprietà modulo","action":"Azione","method":"Metodo","encoding":"Codifica"},"hidden":{"title":"Proprietà campo nascosto","name":"Nome","value":"Valore"},"select":{"title":"Proprietà menu di selezione","selectInfo":"Info","opAvail":"Opzioni disponibili","value":"Valore","size":"Dimensione","lines":"righe","chkMulti":"Permetti selezione multipla","required":"Richiesto","opText":"Testo","opValue":"Valore","btnAdd":"Aggiungi","btnModify":"Modifica","btnUp":"Su","btnDown":"Gi","btnSetValue":"Imposta come predefinito","btnDelete":"Rimuovi"},"textarea":{"title":"Proprietà area di testo","cols":"Colonne","rows":"Righe"},"textfield":{"title":"Proprietà campo di testo","name":"Nome","value":"Valore","charWidth":"Larghezza","maxChars":"Numero massimo di caratteri","required":"Richiesto","type":"Tipo","typeText":"Testo","typePass":"Password","typeEmail":"Email","typeSearch":"Cerca","typeTel":"Numero di telefono","typeUrl":"URL"}},"format":{"label":"Formato","panelTitle":"Formato","tag_address":"Indirizzo","tag_div":"Paragrafo (DIV)","tag_h1":"Titolo 1","tag_h2":"Titolo 2","tag_h3":"Titolo 3","tag_h4":"Titolo 4","tag_h5":"Titolo 5","tag_h6":"Titolo 6","tag_p":"Normale","tag_pre":"Formattato"},"horizontalrule":{"toolbar":"Inserisci riga orizzontale"},"iframe":{"border":"Mostra il bordo","noUrl":"Inserire l'URL del campo IFrame","scrolling":"Abilita scrollbar","title":"Proprietà IFrame","toolbar":"IFrame","tabindex":"Rimuovi da tabindex"},"image":{"alt":"Testo alternativo","border":"Bordo","btnUpload":"Invia al server","button2Img":"Vuoi trasformare il bottone immagine selezionato in un'immagine semplice?","hSpace":"HSpace","img2Button":"Vuoi trasferomare l'immagine selezionata in un bottone immagine?","infoTab":"Informazioni immagine","linkTab":"Collegamento","lockRatio":"Blocca rapporto","menu":"Proprietà immagine","resetSize":"Reimposta dimensione","title":"Proprietà immagine","titleButton":"Proprietà bottone immagine","upload":"Carica","urlMissing":"Manca l'URL dell'immagine.","vSpace":"VSpace","validateBorder":"Il campo Bordo deve essere un numero intero.","validateHSpace":"Il campo HSpace deve essere un numero intero.","validateVSpace":"Il campo VSpace deve essere un numero intero."},"indent":{"indent":"Aumenta rientro","outdent":"Riduci rientro"},"smiley":{"options":"Opzioni Smiley","title":"Inserisci emoticon","toolbar":"Emoticon"},"language":{"button":"Imposta lingua","remove":"Rimuovi lingua"},"link":{"acccessKey":"Scorciatoia da tastiera","advanced":"Avanzate","advisoryContentType":"Tipo della risorsa collegata","advisoryTitle":"Titolo","anchor":{"toolbar":"Inserisci/Modifica Ancora","menu":"Proprietà ancora","title":"Proprietà ancora","name":"Nome ancora","errorName":"Inserici il nome dell'ancora","errorWhitespace":"Il nome delle ancore non può contenere caratteri di spaziatura","remove":"Rimuovi l'ancora"},"anchorId":"Per id elemento","anchorName":"Per Nome","charset":"Set di caretteri della risorsa collegata","cssClasses":"Nome classe CSS","download":"Forza scaricamento","displayText":"Mostra testo","emailAddress":"Indirizzo E-Mail","emailBody":"Corpo del messaggio","emailSubject":"Oggetto del messaggio","id":"Id","info":"Informazioni collegamento","langCode":"Direzione scrittura","langDir":"Direzione scrittura","langDirLTR":"Da Sinistra a Destra (LTR)","langDirRTL":"Da Destra a Sinistra (RTL)","menu":"Modifica collegamento","name":"Nome","noAnchors":"(Nessuna ancora disponibile nel documento)","noEmail":"Devi inserire un'indirizzo e-mail","noUrl":"Devi inserire l'URL del collegamento","noTel":"Inserire il numero di telefono","other":"<altro>","phoneNumber":"Numero di telefono","popupDependent":"Dipendente (Netscape)","popupFeatures":"Caratteristiche finestra popup","popupFullScreen":"A tutto schermo (IE)","popupLeft":"Posizione da sinistra","popupLocationBar":"Barra degli indirizzi","popupMenuBar":"Barra del menu","popupResizable":"Ridimensionabile","popupScrollBars":"Barre di scorrimento","popupStatusBar":"Barra di stato","popupToolbar":"Barra degli strumenti","popupTop":"Posizione dall'alto","rel":"Relazioni","selectAnchor":"Scegli Ancora","styles":"Stile","tabIndex":"Ordine di tabulazione","target":"Destinazione","targetFrame":"<riquadro>","targetFrameName":"Nome del riquadro di destinazione","targetPopup":"<finestra popup>","targetPopupName":"Nome finestra popup","title":"Collegamento","toAnchor":"Ancora nel testo","toEmail":"E-Mail","toUrl":"URL","toPhone":"Telefono","toolbar":"Collegamento","type":"Tipo di Collegamento","unlink":"Elimina collegamento","upload":"Carica"},"list":{"bulletedlist":"Inserisci/Rimuovi Elenco Puntato","numberedlist":"Inserisci/Rimuovi Elenco Numerato"},"liststyle":{"bulletedTitle":"Proprietà liste puntate","circle":"Cerchio","decimal":"Decimale (1, 2, 3, ecc.)","disc":"Disco","lowerAlpha":"Alfabetico minuscolo (a, b, c, d, e, ecc.)","lowerRoman":"Numerazione Romana minuscola (i, ii, iii, iv, v, ecc.)","none":"Nessuno","notset":"<non impostato>","numberedTitle":"Proprietà liste numerate","square":"Quadrato","start":"Inizio","type":"Tipo","upperAlpha":"Alfabetico maiuscolo (A, B, C, D, E, ecc.)","upperRoman":"Numerazione Romana maiuscola (I, II, III, IV, V, ecc.)","validateStartNumber":"Il numero di inizio di una lista numerata deve essere un numero intero."},"magicline":{"title":"Inserisci paragrafo qui"},"maximize":{"maximize":"Massimizza","minimize":"Minimizza"},"newpage":{"toolbar":"Nuova pagina"},"pagebreak":{"alt":"Interruzione di pagina","toolbar":"Inserisci interruzione di pagina per la stampa"},"pastetext":{"button":"Incolla come testo semplice","pasteNotification":"Premere %1 per incollare. Il tuo browser non permette di incollare tramite il pulsante della barra degli strumenti o tramite la voce del menu contestuale.","title":"Incolla come testo semplice"},"pastefromword":{"confirmCleanup":"Il testo da incollare sembra provenire da Word. Desideri pulirlo prima di incollare?","error":"Non è stato possibile eliminare il testo incollato a causa di un errore interno.","title":"Incolla da Word","toolbar":"Incolla da Word"},"preview":{"preview":"Anteprima"},"print":{"toolbar":"Stampa"},"removeformat":{"toolbar":"Elimina formattazione"},"save":{"toolbar":"Salva"},"selectall":{"toolbar":"Seleziona tutto"},"showblocks":{"toolbar":"Visualizza Blocchi"},"sourcearea":{"toolbar":"Sorgente"},"specialchar":{"options":"Opzioni carattere speciale","title":"Seleziona carattere speciale","toolbar":"Inserisci carattere speciale"},"scayt":{"btn_about":"About COMS","btn_dictionaries":"Dizionari","btn_disable":"Disabilita COMS","btn_enable":"Abilita COMS","btn_langs":"Lingue","btn_options":"Opzioni","text_title":"Controllo Ortografico Mentre Scrivi"},"stylescombo":{"label":"Stili","panelTitle":"Stili di formattazione","panelTitle1":"Stili per blocchi","panelTitle2":"Stili in linea","panelTitle3":"Stili per oggetti"},"table":{"border":"Dimensione bordo","caption":"Intestazione","cell":{"menu":"Cella","insertBefore":"Inserisci Cella Prima","insertAfter":"Inserisci Cella Dopo","deleteCell":"Elimina celle","merge":"Unisce celle","mergeRight":"Unisci a Destra","mergeDown":"Unisci in Basso","splitHorizontal":"Dividi Cella Orizzontalmente","splitVertical":"Dividi Cella Verticalmente","title":"Proprietà della cella","cellType":"Tipo di cella","rowSpan":"Su più righe","colSpan":"Su più colonne","wordWrap":"Ritorno a capo","hAlign":"Allineamento orizzontale","vAlign":"Allineamento verticale","alignBaseline":"Linea Base","bgColor":"Colore di Sfondo","borderColor":"Colore del Bordo","data":"Dati","header":"Intestazione","columnHeader":"Intestazione colonna","rowHeader":"Intestazione riga","yes":"Si","no":"No","invalidWidth":"La larghezza della cella dev'essere un numero.","invalidHeight":"L'altezza della cella dev'essere un numero.","invalidRowSpan":"Il numero di righe dev'essere un numero intero.","invalidColSpan":"Il numero di colonne dev'essere un numero intero.","chooseColor":"Scegli"},"cellPad":"Padding celle","cellSpace":"Spaziatura celle","column":{"menu":"Colonna","insertBefore":"Inserisci Colonna Prima","insertAfter":"Inserisci Colonna Dopo","deleteColumn":"Elimina colonne"},"columns":"Colonne","deleteTable":"Cancella Tabella","headers":"Intestazione","headersBoth":"Entrambe","headersColumn":"Prima Colonna","headersNone":"Nessuna","headersRow":"Prima Riga","heightUnit":"unità altezza","invalidBorder":"La dimensione del bordo dev'essere un numero.","invalidCellPadding":"Il paging delle celle dev'essere un numero","invalidCellSpacing":"La spaziatura tra le celle dev'essere un numero.","invalidCols":"Il numero di colonne dev'essere un numero maggiore di 0.","invalidHeight":"L'altezza della tabella dev'essere un numero.","invalidRows":"Il numero di righe dev'essere un numero maggiore di 0.","invalidWidth":"La larghezza della tabella dev'essere un numero.","menu":"Proprietà tabella","row":{"menu":"Riga","insertBefore":"Inserisci Riga Prima","insertAfter":"Inserisci Riga Dopo","deleteRow":"Elimina righe"},"rows":"Righe","summary":"Indice","title":"Proprietà tabella","toolbar":"Tabella","widthPc":"percento","widthPx":"pixel","widthUnit":"unità larghezza"},"undo":{"redo":"Ripristina","undo":"Annulla"},"widget":{"move":"Fare clic e trascinare per spostare","label":"Widget %1"},"uploadwidget":{"abort":"Caricamento interrotto dall'utente.","doneOne":"Il file è stato caricato correttamente.","doneMany":"%1 file sono stati caricati correttamente.","uploadOne":"Caricamento del file ({percentage}%)...","uploadMany":"Caricamento dei file, {current} di {max} completati ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Codice Sorgente","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Cerca emoji…","searchLabel":"Campo di input responsabile di ricerca e filtro delle emoji all'interno del pannello.","navigationLabel":"Navigazione tra gruppi per le sezioni di emoji.","title":"Elenco emoji","groups":{"people":"Persone","nature":"Natura e animali","food":"Cibo e bevande","travel":"Viaggio e luoghi","activities":"Attività","objects":"Oggetti","symbols":"Simboli","flags":"Bandiere"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Sorgente","title":"Sorgente"}};